<h3>What does it do?</h3>
  <p>This module is used by the Orders module to complete purchases using Paypals Website Payment Standard mechanism.  The module uses the PDT method for completing a purchase, and optionally supports IPN functionality.  After a successful checkout, users will redirect back to the Orders module to show the checkout receipt page.  See <a href="http://calguy1000.com/Blogs/8/60/cmsms-quick-e-commerce-how-to.html">http://calguy1000.com/Blogs/8/60/cmsms-quick-e-commerce-how-to.html</a>  for more information on how to setup the Cart, Orders and other associated modules.</p>
<h3>How Do I use It</h3>
<p>First you should enable PDT in your paypal business account, and keep track of the PDT identity token as supplied by paypal.</p>
<p>For IPN support you will need to enable PDT in your paypal business acocount, and enter a return URL, though this url is overridden by this module and can be ignored.</p>
<p>Thirdly, you should adjust the language settings in your paypal business account to ensure they are set to utf-8.</p>
<p>Next, once all of the dependencies are installed, you simply install the module.  then configure the module PaypalGateay control panel inside the CMS Made Simple admin console.  Specify the url to use for paypal transactions (the test url is provided by default), your paypal associated email address, and the PDT identity token as described above.</p>
<p>Thirdly, navigate to the preferences tab in the Orders module and select this module as your chosen payment gateway.</p>
<h3>Limitations</h3>
<p>The Website Payment Standard API from Paypal is rather limited in its functionality, therefore a number of steps have been taken to overcome as much as possible these limitations:</p>
<ul>
<li>Taxes:
<p>At the time of writing, the WPS standard did not support multiple taxes, but the Orders module does, Therefore all taxes are entered as line items.</p>
</li>

<li>Shipping:
<p>At the time of writing, the WPS standard did not support shipping costs, or descriptions for shipping, however the Orders module is moving in that direction, Therefore all shipping costs are entered as line items.</p>
</li>

<li>Discounts / Negative Values:
<p>At the time of writing, the WPS standard did not support negative amount values for items such as discounts.  However, the Promotions module does.  Therefore if a negative value is detected in the items provided to this module, the module will munge the entire order into one line item of the appropriate amount.</p>
</li>

<li>Item Numbers:
<p>Paypal seems to require item numbers for all line items.  And since tax and shipping line items dont necessarily have a product id, all item numbers start from 1 and are linearly incremented.</p>
</li>

<li>Chargebacks/Reversals etc.
<p>Although the paypal IPN protocol is capable of handling thse types of transactions, the Orders module at the time of writing is not.  Therefore many of these are ignored, or the order will be adjusted to have an ERROR status.</p>
</li>

</ul>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit the cms development forge at <a href="http://dev.cmsmadesimple.org">dev.cmsmadesimple.org</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000 all can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author(s) directly.</li>  
</ul>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>