<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: PaypalGateway (c) 2009 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#  An addon module for CMS Made Simple to provide the ability to process
#  Payments made using the E-commerce suite through the AuthNet payment
#  gateway.
#
# Note: This module was originally started by Ted Kulp, but rewritten
# under the same name by Robert Campbell.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

if( !isset($params['mycustom']) )
  {
    $this->SetError($this->Lang('error_missing_custom_verifier'));
    $this->Audit('',$this->GetName().':return_success',$this->Lang('error_missing_custom_verifier'));
  }
else if( !isset($params['order_id']) )
  {
    $this->SetError($this->Lang('error_ipn_invalid_orderid'));
    $this->Audit('',$this->GetName().':return_success',$this->Lang('error_ipn_invalid_orderid'));
  }

if( $this->GetPreference('enable_ipn',0) )
  {
    // nothing more to do... IPN will contain the rest of the info.
    $this->RestoreState($params['mycustom']);
    $this->SetStatus(PAYMENT_STATUS_NONE);
    $this->FinishTransaction();
  }
else if( !isset($_REQUEST['tx']) && !isset($_REQUEST['txn_id']) )
  {
    $this->RestoreState($params['mycustom']);
    $this->SetError($this->Lang('error_transaction_id_missing'));
    $this->Audit('',$this->GetName().':return_success',$this->Lang('error_transaction_id_missing'));
  }
else
  {
    $this->RestoreState($params['mycustom']);
    if( !$this->CheckInfo() )
      {
	$this->SetError($this->Lang('error_restoring_transaction_state'));
      }
    else
      {
	// we got a valid redirect from paypal.
	$url = '';
	$token = '';
	if( $this->GetPreference('prodmode',0) )
	  {
	    $url = Sagepay2::PROD_URL;
	    $token = $this->GetPreference('prod_token');
	  }
	else
	  {
	    $url = Sagepay2::TEST_URL;
	    $token = $this->GetPreference('test_token');
	  }
	$config = $gCms->GetConfig();
	$tmp = '';
	$amt = '';
	$txn_id = '';
	$currency = '';
	$stat = $_REQUEST['st'];
	$txn_id = '';
	if( isset($_REQUEST['tx']) )
	  {
	    $txn_id = trim($_REQUEST['tx']);
	  }
	else if( isset($_REQUEST['txn_id']) )
	  {
	    $txn_id = trim($_REQUEST['txn_id']);
	  }

	if( isset($_REQUEST['amt']) )
	  {
	    $amt = $_REQUEST['amt'];
	  }
	else if( isset($_REQUEST['mc_gross']) )
	  {
	    $amt = $_REQUEST['mc_gross'];
	  }

	if( empty($amt) )
	  {
	    $this->Audit('',$this->GetName().':return_success',$this->lang('error_transaction_invalid_amount'));
	  }
	else if( isset($this->_data['amount']) && $amt != $this->_data['amount'] )
	  {
	    // amount is invalid, that's wonky
	    $this->Audit('',$this->GetName().':return_success',$this->lang('error_transaction_invalid_amount'));
	  }

	if( isset($_REQUEST['cc']) )
	  {
	    $currency = $_REQUEST['cc'];
	  }
	else if( isset($_REQUEST['mc_currency']) )
	  {
	    $currency = $_REQUEST['mc_currency'];
	  }

	if( empty($currency) )
	  {
	    $this->Audit('',$this->GetName().':return_success',$this->lang('error_transaction_invalid_currency'));
	  }
	else if( $currency != cg_ecomm::get_currency_code() )
	  {
	    $this->Audit('',$this->GetName().':return_success',$this->lang('error_transaction_invalid_currency'));
	  }

	$this->SetTransactionId($txn_id);
	$this->SetTransactionAmount($amt);
	$this->SetStatus(PAYMENT_STATUS_PENDING);

	if( $this->GetPreference('enable_ipn') )
	  {
	    $this->SetStatus(PAYMENT_STATUS_NONE);
	    $this->Audit('',$this->GetName().':return_success',$this->Lang('msg_transaction_waitingipn',$txn_id,$this->_data['invoice']));
	    $this->FinishTransaction();
	    return;
	  }
	else if( empty($token) ||
	    (isset($config['paypal_skip_pdt']) && $config['paypal_skip_pdt'] == 1) )
	  {
	    // skip the pdt stuff.
	    $this->Audit('',$this->GetName().':return_success',$this->Lang('msg_transaction_success_nopdt',$txn_id));
	    $this->SetStatus(PAYMENT_STATUS_APPROVED);
	    $this->FinishTransaction();
	    return;
	  }

	// IPN is disabled, and we can do PDT
	$postdata = array();
	$postdata['tx'] = $txn_id;
	$postdata['at'] = $token;
	$postdata['cmd'] = '_notify-synch';
	$tmp = $this->http_post($url,$postdata);

	if( empty($tmp) && !empty($token) )
	  {
	    // pdt failed.
	    $this->SetError($this->Lang('error_retrieving_transaction_data'));
	  }
	else if( !empty($token) )
	  {

	    $tmp2 = explode("\n",$tmp);
	    $result = array();
	    for( $i = 0; $i < count($tmp2); $i++ )
	      {
		$str = trim($tmp2[$i]);
		if( empty($str) ) continue;
		if( $i == 0 )
		  {
		    $result['STATUS'] = $str;
		  }
		else
		  {
		    if( strstr($str,'=') !== FALSE )
		      {
			list($k,$v) = explode('=',$str,2);
			$result[$k] = $v;
		      }
		  }
	      }

	    if( $result['STATUS'] != 'SUCCESS' || !isset($result['txn_id']) )
	      {
		// strange pdt problem.
		$this->SetError($this->Lang('error_transaction_pdt_failed').' - status = '.$result['STATUS']);
		$this->Audit('',$this->GetName().':return_success',$this->Lang('error_transaction_pdt_failed'));
	      }
	    else
	      {
		$this->SetTransactionId($txn_id);
		if( $this->GetPreference('enable_ipn',0) )
		  {
		    $this->Audit('',$this->GetName().':return_success',$this->Lang('msg_transaction_waitingipn',$result['txn_id'],$this->_data['invoice']));
		    $this->SetStatus(PAYMENT_STATUS_PENDING);
		  }
		else
		  {
		    $this->Audit('',$this->GetName().':return_success',$this->Lang('msg_transaction_success',$result['txn_id']));
		    $this->SetStatus(PAYMENT_STATUS_APPROVED);
		  }
	      }
	  }
      }
  }

$this->FinishTransaction();

// EOF
?>
