<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: PaypalGateway (c) 2009 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#  An addon module for CMS Made Simple to provide the ability to process
#  Payments made using the E-commerce suite through the AuthNet payment
#  gateway.
#
# Note: This module was originally started by Ted Kulp, but rewritten
# under the same name by Robert Campbell.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->GetPreference('enable_ipn',0) ) exit;

require_once(dirname(dirname(__FILE__)).'/CGExtensions/lib/http/class.http.php');

// prepare our postback
$postdata = $_POST;
$postdata['cmd'] = '_notify-validate';
$url = '';
if( $this->GetPreference('prodmode',0) ) {
  $url = Sagepay2::PROD_URL;
}
else {
  $url = Sagepay2::TEST_URL;
}

$http = new Http;
$http->setMethod('POST');
$http->setParams($postdata);
$tmp = $http->execute($url);
$error = $http->getError();

if( empty($tmp) ) {
  // POST failed... do an Audit and exit.
  $this->Audit('',$this->GetName().':ipn',$this->Lang('error_ipn_verification_failed').' -- '.$error);
  exit;
 }

// woot, the transaction is verified.... we should have an order id, and a transaction id
// and a bunch of other stuff that we can deal with.
if( !isset($_POST['custom']) || $_POST['custom'] == '' ) {
  $this->Audit('',$this->GetName().':ipn',$this->Lang('error_ipn_invalid_data'));
  exit;
}
else if( !isset($_POST['txn_type']) ) {
  // this should never ever happen.
  $this->Audit('',$this->GetName().':ipn',$this->Lang('error_ipn_invalid_data'));
  exit;
}

$order_id = (int)$_POST['custom'];
$txn_id = '';
if( isset($_POST['txn_id']) ) {
  $txn_id = trim($_POST['txn_id']);
}

$amount = '';
if( isset($_POST['mc_gross']) )
  $amount = $_POST['mc_gross'];
 else if( isset($_POST['payment_gross']) )
   $amount = $_POST['payment_gross'];
 else if( isset($_POST['payment_amount']) )
   $amount = $_POST['payment_amount'];
switch( $_POST['txn_type'] ) {
 case 'cart':
   switch( strtolower($_POST['payment_status']) ) {
   case 'processed':
   case 'completed':
     // all good, we can set this order in process.
     $this->ProcessAsyncTransaction($order_id,$txn_id,PAYMENT_STATUS_APPROVED,$amount);
     break;

   case 'failed':
   case 'denied':
     // not good... no funds.
     $this->ProcessAsyncTransaction($order_id,$txn_id,PAYMENT_STATUS_DECLINED,0);
     break;

   case 'expired':
   case 'reversed':
   case 'pending':
   case 'voided':
     // uh-oh something happened.
     $this->ProcessAsyncTransaction($order_id,$txn_id,PAYMENT_STATUS_OTHER,0);
     break;

   }
   break;

 case 'subscr_signup':
   // silently ignore.
   break;

 case 'subscr_payment':
   $transaction = new cgpgb_async_transaction($order_id,$amount);
   $transaction->set_status(PAYMENT_STATUS_APPROVED);
   $transaction->set_id($txn_id);
   if( isset($_POST['subscr_id']) ) {
     $transaction->set_other_val('Subscription ID',$_POST['subscr_id']);
   }
   $this->send_transaction_notification($transaction);
   break;

 case 'subscr_cancel':
   $transaction = new cgpgb_async_transaction($order_id,$_POST['amount3']);
   $transaction->set_status(PAYMENT_STATUS_CANCELLED);
   $transaction->set_id($txn_id);
   if( isset($_POST['subscr_id']) ) {
     $transaction->set_other_val($_POST['subscr_id']);
   }
   $this->send_transaction_notification($transaction);
   break;

 default:
   $this->Audit('',$this->GetName().':ipn','Unhandled transaction type: '.$_POST['txn_type']);
   exit;
 }

// nothing more to do
$this->Audit('',$this->GetName().':ipn','IPN Transaction '.$_POST['txn_id'].' successful. Status: '.$_POST['payment_status'].', amount: '.$amount);
#
# EOF
#
?>
