The following examples can be found in full at http://liquidmarkup.org/

Liquid is an extraction from the e-commerce system Shopify.
Shopify powers many thousands of e-commerce stores which all call for unique designs.
For this we developed Liquid which allows our customers complete design freedom while
maintaining the integrity of our servers.

Liquid has been in production use since June 2006 and is now used by many other
hosted web applications.

It was developed for usage in Ruby on Rails web applications and integrates seamlessly
as a plugin but it also works excellently as a stand alone library.

Here's what it looks like:

  <ul id="products">
    {% for product in products %}
      <li>
        <h2>{{ product.title }}</h2>
        Only {{ product.price | format_as_money }}

        <p>{{ product.description | prettyprint | truncate: 200  }}</p>

      </li>
    {% endfor %}
  </ul>


Some more features include:

<h2>Filters</h2>
<p> The word "tobi" in uppercase: {{ 'tobi' | upcase }} </p>
<p>The word "tobi" has {{ 'tobi' | size }} letters! </p>
<p>Change "Hello world" to "Hi world": {{ 'Hello world' | replace: 'Hello', 'Hi' }} </p>
<p>The date today is {{ 'now' | date: "%Y %b %d" }} </p>


<h2>If</h2>
<p>
  {% if user.name == 'tobi' or user.name == 'marc' %} 
    hi marc or tobi
  {% endif %}
</p>


<h2>Case</h2>
<p>
  {% case template %}
    {% when 'index' %}
       Welcome
    {% when 'product' %}
       {{ product.vendor | link_to_vendor }} / {{ product.title }}
    {% else %}
       {{ page_title }}
  {% endcase %}
</p>


<h2>For Loops</h2>
<p>
  {% for item in array %} 
    {{ item }}
  {% endfor %}
</p>


<h2>Tables</h2>
<p>
  {% tablerow item in items cols: 3 %}
    {% if tablerowloop.col_first %}
      First column: {{ item.variable }}
    {% else %}
      Different column: {{ item.variable }}
    {% endif %}
  {% endtablerow %}
</p>
