<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
# Method: Install
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$db = cmsms()->GetDB();

$taboptarray = array( 'mysql' => 'ENGINE=MyISAM' );

$dict = NewDataDictionary( $db );

// create tables
$flds = "
	gbook_id I KEY AUTO,
	name C(100),
	alias C(100),
	entries_page I,
	prevent_post_twice L,
	use_captcha L,
	allow_rating L,
	allow_smilies L,
	allow_notifications L,
	notification_subject C(255),
	notification_message X,
	submission_response X,
	submission_response_spam X,
	admin_notification_subject C(255),
	admin_notification_message X,
	required_fields C(255),
	active L
";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_gbook", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
	entry_id I KEY AUTO,
	gbook_id I,
	name C(255),
	email C(255),
	title C(255),
	message X,
	rating I,
	notify L,
	ip C(40),
	create_date " . CMS_ADODB_DT . ",
	modified_date " . CMS_ADODB_DT . ",
	approved I,
	approved_date " . CMS_ADODB_DT . ",
	approved_by I,
	activation_code C(40),
	spamrate I,
	active L
";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_gbook_entries", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$sqlarray = $dict->CreateIndexSQL(cms_db_prefix()."members_gbook_idx", cms_db_prefix()."module_gbook_entries", "gbook_id");
$dict->ExecuteSQLArray($sqlarray);

$flds = "
	smiley_id I KEY AUTO,
	smiley_file C(100),
	smiley_code C(20),
	sort I,
	active L
";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_gbook_smileys", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
	token C(255) KEY,
	count_ham I,
	count_spam I
";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_gbook_b8_wordlist", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);


// create default Guestbook
$query = "INSERT INTO ".cms_db_prefix()."module_gbook (
						name, 
						alias, 
						entries_page, 
						prevent_post_twice,
						use_captcha,
						allow_rating, 
						allow_smilies, 
						allow_notifications, 
						submission_response,
						submission_response_spam,
						admin_notification_subject,
						admin_notification_message,
						required_fields,
						active) 
					VALUES
						(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
$result = $db->Execute($query, array(
						'MyFirstGbook', 
						'myfistgbook', 
						10, 
						0,
						0,
						0,
						1, 
						0, 
						$this->Lang('submission_response_cnt'),
						$this->Lang('submission_response_spam_cnt2'),
						$this->Lang('admin_notification_subject_cnt'),
						$this->Lang('admin_notification_message_cnt'),
						'name,email',
						1));
$this->SetPreference('defaultgbook', 1);

// fill smileys dir, only if there aren't any images already.
$images = glob(cms_join_path($this->GetModulePath(), 'smileys', '*.{jpg,JPG,png,PNG}'), GLOB_BRACE);
//debug_display($images, 'Start Smileys');
if ( empty($images) )
{
	$i = 0;
	$query = "INSERT INTO ".cms_db_prefix()."module_gbook_smileys (smiley_file, smiley_code, sort, active) VALUES (?,?,?,?)";
	$smileys = array(
			'smile.png' => ':)',
			'laughing.png' => ':D',
			'wink.png' => ';)',
			'cool.png' => '8)',
			'tongue-out.png' => ':P',
			'surprised.png' => ':O',
			'kiss.png' => ':{}',
			'embarassed.png' => ':}',
			'sealed.png' => ':X',
			'innocent.png' => 'O:)',
			'undecided.png' => ':/',
			'frown.png' => ':(',
			'cry.png' => ":'(",
			'yell.png' => ':(0)',
			'foot-in-mouth.png' => ':!',
			'money-in-mouth.png' => ':$');
	foreach ( $smileys as $file => $code )
	{
		$filepath_from = cms_join_path(dirname(__FILE__), 'images', 'default_smileys', $file);
		$filepath_to = cms_join_path(dirname(__FILE__), 'smileys', $file);
		if ( file_exists($filepath_from) && copy($filepath_from, $filepath_to) )
		{
			$result = $db->Execute($query, array($file, $code, $i++, 1));
		}
	}	
}

// insert initial records for b8
$query = "INSERT INTO ".cms_db_prefix()."module_gbook_b8_wordlist (token, count_ham, count_spam) VALUES (?,?,?)";
$result = $db->Execute($query, array('b8*dbversion', 3, 0));
$query = "INSERT INTO ".cms_db_prefix()."module_gbook_b8_wordlist (token, count_ham, count_spam) VALUES (?,?,?)";
$result = $db->Execute($query, array('b8*texts', 0, 0));


// create a permission
$this->CreatePermission('Gbook: Use', 'Gbook: Use');
$this->CreatePermission('Gbook: Modify', 'Gbook: Modify');


// setup templates
$templates = array('summary_tpl_guestbook', 'detail_tpl_message', 'form_tpl_form');

foreach ( $templates as $template )
{
	$fn = cms_join_path(dirname(__FILE__), 'templates', $template . '.txt');
	if( file_exists($fn) )
	{
		$templatecode = @file_get_contents($fn);
		$this->SetTemplate($template, $templatecode);
		list($tpl_type, $tpl_name) = explode('_tpl_', $template, 2);
		$this->SetPreference('default_' . $tpl_type . '_template', $template);
	}
}


// setup sample stylesheet
$fn = cms_join_path(dirname(__FILE__), 'templates', 'stylesheet.css');
$txt = file_get_contents($fn);
$css = new CmsLayoutStylesheet;
$css->set_name('Gbook module');
$css->set_description('sample stylesheet for Gbook module');
$css->set_content($txt);
$css->save();


// create preferences
$this->SetPreference('custom_modulename', $this->Lang('friendlyname'));
$this->SetPreference('admin_section', 'content');
$send_notifications_to[0] = get_userid();
$this->SetPreference('send_notifications_to', serialize($send_notifications_to));
$this->SetPreference('max_spamrate_active', 0.6);
$this->SetPreference('max_spamrate_notify', 0.9);
$this->SetPreference('max_spamrate_save', 0.9);
$this->SetPreference('badwords', '');


// register events 
$this->CreateEvent('Gbook_entry_added');
$this->CreateEvent('Gbook_entry_edited');
$this->CreateEvent('Gbook_entry_deleted');


$this->RegisterModulePlugin(TRUE);
/*
	$route = new CmsRoute('/[Gg]book\/(?P<alias>[0-9]+)-(?P<gbpage>[0-9]+)\/(?P<returnid>[0-9]+)$/', $this->GetName());
	cms_route_manager::add_static($route);
	$route = new CmsRoute('/[Gg]book\/(?P<entryid>[0-9]+)\/(?P<returnid>[0-9]+)$/', $this->GetName());
	cms_route_manager::add_static($route);
*/

?>