<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

$lang['friendlyname'] = 'Guestbooks';
$lang['moddescription'] = 'Create and manage guestbooks to get some feedback from your site visitors';
$lang['description'] = 'Get some feedback from your site visitors';
$lang['postinstall'] = 'The Gbook module was successfully installed. Check the admin Content section for \'%s\'.';

$lang['spam'] = 'Spam';
$lang['areyousure'] = 'Are you sure you want to delete?';
$lang['areyousuremulti'] = 'Are you sure you want to execute this bulk action?';


$lang['gbooks'] = 'Guestbooks';
$lang['addgbook'] = 'Add Guestbook';
$lang['gbookadded'] = 'Guestbook is added';
$lang['editgbook'] = 'Edit Guestbook';
$lang['gbookupdated'] = 'Guestbook is updated';
$lang['gbookdeleted'] = 'Guestbook is deleted';
$lang['entries_page'] = 'Number of entries per page';
$lang['prevent_post_twice'] = 'Prevent consecutive messages by the same user (based on IP address)';
$lang['use_captcha'] = 'Use captcha to activate spam-suspected messages (Captcha module needs to be installed)';
$lang['allow_rating'] = 'Allow Star rating';
$lang['allow_smilies'] = 'Allow Smilies';
$lang['allow_notifications'] = 'Enable Notifications option';
$lang['notification_subject'] = 'Notification email subject';
$lang['notification_message'] = 'Notification email message';
$lang['submission_response'] = 'Response on form submission';
$lang['submission_response_spam'] = 'Response on suspected spam form submission';
$lang['admin_notification_subject'] = 'Admin notification email subject';
$lang['admin_notification_message'] = 'Admin notification email message';
$lang['required_fields'] = 'Required Fields on Frontend';
$lang['import_csv'] = 'Import entries by csv';
$lang['csv_format'] = 'csv format: "author"[string];"email"[string];"title"[string];"message"[string];"ip"[string];"create_date"[date/time:yyyy-mm-dd hh:mm:ss]';


$lang['smileys'] = 'Smileys';
$lang['smiley'] = 'Smiley';
$lang['addsmiley'] = 'Add Smiley';


$lang['id'] = 'ID';
$lang['spamrate'] = 'Spam Rating';
$lang['created'] = 'Created';
$lang['modified'] = 'Modified';
$lang['approved'] = 'Approved';
$lang['itemadded'] = 'Entry is added';
$lang['edititem'] = 'Edit Entry';
$lang['itemupdated'] = 'Entry is updated';
$lang['itemdeleted'] = 'Entry is deleted';

$lang['saveasham'] = 'Mark entry as "Ham"';
$lang['saveasspam'] = 'Mark entry as "Spam"';
$lang['deletefromham'] = 'Unmark entry from "Ham"';
$lang['deletefromspam'] = 'Unmark entry from "Spam"';


//Templates
$lang['summary_tpl'] = 'summary view';
$lang['detail_tpl'] = 'detail view';
$lang['form_tpl'] = 'frontend submit form';
//$lang['email_tpl'] = 'email text';
$lang['default_summary_template'] = 'Default summary template';
$lang['default_detail_template'] = 'Default detail template';
$lang['resetdefault'] = 'Load/reset default template';
$lang['resetwarning'] = 'Are you sure you want to reset the template code to default?';
//$lang['availablevariables'] = 'Available Template Smarty Variables';


//Options
$lang['title_custom_modulename'] = 'Custom Modulename';
$lang['help_custom_modulename'] = 'You can change the Modulename here as you wish. It will be used as the title on the module admin pages and as menu text.';
$lang['title_admin_section'] = 'Admin Section';
$lang['help_admin_section'] = 'Choose the Admin Section (or top-level Admin Menu) this module belongs to.';
$lang['send_notifications_to'] = 'Send notification of new entries to editor';
//$lang['not_send_spamnotifications'] = 'Do not send notifications for suspected spam entries';
$lang['max_spamrate_active'] = 'Maximum spamrating to automatically set an entry active on submit';
$lang['max_spamrate_active_help'] = 'between 0 and 1, default 0.6. Lower value means tighter setting. Advised to set on 0.4 or below';
$lang['max_spamrate_notify'] = 'Maximum spamrating for sending a notification to editor';
$lang['max_spamrate_notify_help'] = 'between 0 and 1, default 0.9. Higher value will increase the chance of getting notifications of spam entries.';
$lang['max_spamrate_save'] = 'Maximum spamrating for saving a new entry';
$lang['max_spamrate_save_help'] = 'between 0 and 1, default 0.9. Lower value will increase the chance of losing legitimate entries.';
$lang['badwords'] = 'Filter bad words (comma separated)';
$lang['optionsupdated'] = 'The options were successfully updated.';


//Frontend
$lang['entries'] = 'Entries';
$lang['name'] = 'Name';
$lang['email'] = 'Email';
$lang['title'] = 'Title';
$lang['message'] = 'Message';
$lang['rating'] = 'Rating';
$lang['notify'] = 'Notify me on new messages';
$lang['fe_submit'] = 'Submit';
$lang['validation_errors'] = 'Please provide a valid entry for the marked fields and submit again.';
$lang['double_post'] = '<p>Thank you for your feedback. Your message already has been added to our guestbook.</p>';
$lang['not_allowed_to_post_twice'] = '<p>Sorry. Due to spam protection it is not possible to post two consecutive messages. We are realy sorry for this inconvenience.</p>
<p>Please try again later, or send us an email so we can add your message to our website.</p>';


//Default Gbook message settings
$lang['submission_response_cnt'] = '<p>Thank you for your feedback. Your message has been added to our guestbook.</p>';
$lang['submission_response_spam_cnt2'] = '<p>Thank you for your feedback.</p>
{if empty($gbook_captcha)}
<p>Your message however has been suspected to contain spam, therefore it needs approval before it will be displayed.</p>
<p>Please notify us by sending an email.</p>
{else}
<p>Your message however has been suspected to contain spam, therefore it needs one next step before it will be displayed.</p>
<p>Please complete the following challenge:</p>
{$gbook_captcha} {$gbook_captcha_input}
{/if}';
$lang['admin_notification_subject_cnt'] = 'New Guestbook Entry';
$lang['admin_notification_message_cnt'] = 'You received a new message in your {sitename} Guestbook.

Check it on: {root_url}';


//Help
$lang['help_action'] = 'Possible values: <ul><li>\'default\' - for displaying the guestbook entries</li><li>\'form\' - for displaying a form</li><li>\'detail\' - for displaying a single entry, e.g. as search result</li></ul>';
$lang['help_alias'] = 'Use another guestbook than the default one. Check the Guestbooks-tab, column \'Tags\', to see which aliases can be used.';
$lang['help_entryid'] = 'Use this parameter along with <code>action=\'detail\'</code> if you want to display only one guestbook entry. To get the latest entry, use <code>entryid=-1</code>';
$lang['help_template'] = 'Use another template than the default one. Note that templates must be of the proper type, in accordance with the action parameter.';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>The Gbook module provides your site visitors a convenient way to give some feedback on your site. Messages can include smileys and star ratings. Your guestbook is effectively protected from spam without the necessity of using an annoying captcha.</p>
<h3>How Do I Use It</h3>
<p>To show the guestbook entries, just insert the module with the<code> {Gbook} </code>tag into the content section of a page.<br />
You can display a form with the<code> {Gbook action=\'form\'} </code>tag.</p>
<p>To get a quick start, a sample stylesheet has been installed which corresponds with the default module templates. Attach the stylesheet \'Gbook module\' to your page template(s) to give your guestbook a first good look.</p>

<h3>Edit Guestbook Entries</h3>
<p>Users with the \'Gbook: Use\' permission can edit guestbook entries in the backend.</p>

<h3>Spam Protection</h3>
<p>Gbook uses a honeypot field (since version 2.2) which will prevent spam engines from posting. Make sure to keep the {$gbook_honeypot_input} field in your form template, and it stays hidden via css, otherwise nobody will be able to post messages.</p>
<p>Next, Gbook proudly uses the "b8" statistical (Bayesian) spam filter version 0.6.2, written by Tobias Leupold. This built-in spam protection system will only function after you have learned it how to interpret the messages by marking the first few entries as either "Spam" or "Ham". If the system has learned enough good as well as enough spammy words, it will give spam messages a rating somewhere near 1, and ham messages will be rated somewhere near 0. Note that it won\'t be of very much use to manually mark entries as spam or ham, which are already rated as such.</p>
<p>Messages with a rating of 0.50 could not be rated because of too few matching words. Those are the ones you need to pay attention to by marking them as spam or ham.</p>
<p>If you want to know more of this excellent spam protection system, you can visit <a href="http://nasauber.de/opensource/b8/">nasauber.de</a>.</p>
<p>When a new message is suspected to contain spam, though with such a low value that it was saved but not active, you can serve your visitor a chaptcha challenge. For this the Captcha module needs to be installed and the guestbook setting "Use captcha" needs to be checked.</p>

<h3>Customisation</h3>
<p>The Guestbooks-tab in the admin section allows you to create more separate guestbooks. Each can have its own settings.<br />
Users must belong to a group with the \'Gbook: Modify\' permission to be able to create new guestbooks and to change settings.</p>

<h3>Import Guestbook Entries</h3>
<p>If you are migrating your site from another CMS or from another guestbook system, you probably might want to create a csv file containing all entries you have received in the past.</p>
<p>This csv file can easily be imported to Gbook, when it is formatted with fields in a specific order, separated by semicolons and enclosed by double quotes, like this:<br />
<code>"author";"email";"title";"message";"ip";"create_date"</code></p>
<p>All fields are of type [string]. The field <em>create_date</em> needs to be formatted as "yyyy-mm-dd hh:mm:ss"</p>

<h3>Edit Gbook templates</h3>
<p>In order to edit templates, the user must belong to a group with the \'Modify Templates\' permission.</p>

<h3>Global Gbook Options</h3>
<p>To edit the global Gbook options, the user must belong to a group with the \'Modify Site Preferences\' permission.</p>

<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module or to file a Feature Request or Bug Report, please visit the Module Forge
<a href="http://dev.cmsmadesimple.org/projects/gbook/">Gbook Page</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="https://forum.cmsmadesimple.org">CMS Made Simple Forums</a>. You are warmly invited to open a new topic if you didn\'t find an answer to your question.</li>
<li>Lastly, you may have some success emailing the author directly.</li>
</ul>

<h3>Feedback</h3>
<p>If you enjoy this module, use it on a commercial website or would like to encourage future development, you might consider just a small donation.<br />Or leave a message in the <a href="https://forum.cmsmadesimple.org/viewtopic.php?f=7&t=64460">Gbook forum topic</a>. Any kind of feedback will be much appreciated.</p>
';
?>
