<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------


//$gbooks = Gbook_utils::GetGbooks('', false);
$gbook_id = empty($params['gbookid']) ? $this->GetPreference('defaultgbook') : $params['gbookid'];

if ( count($gbooks) > 1 )
{
	// create gbook dropdownfield
	foreach ( $gbooks as $gbook ) 
	{
		$label = $gbook['name'] . ' (' . $gbook['entries'] . ')';
		$gbooklist[$label] = $gbook['gbook_id'];
		//if ( $gbook_id == $gbook['gbook_id'] ) $entries = $gbook['entries'];
	}
	$smarty->assign('gbookselect', $this->CreateInputDropdown($id, 'gbookselect', $gbooklist, -1, $gbook_id, 'id="' . $id . 'gbookselect"'));
	$smarty->assign('gbookselectjs', '
		$(\'#' . $id . 'gbookselect\').change( function() {
			location.href = "' . str_replace('&amp;','&',$this->CreateLink($id, 'defaultadmin', $returnid, '', array('active_tab' => 'items'), '', true))  . '&' . $id . 'gbookid="+$(this).val();
		});
');
}
else
{
	$smarty->assign('gbookselect', '');
	$smarty->assign('gbookselectjs', '');
	//$entries = $gbooks[0]['entries'];
}

// create filter dropdownfield
$params['filter'] = empty($params['filter']) ? 'showall' : $params['filter'];
$filterlist = array(lang('showall') => 'showall', lang('active') => 'active', lang('inactive') => 'inactive', $this->Lang('spam') => 'spam');
$smarty->assign('prompt_filter', lang('filters'));
$smarty->assign('filter', $this->CreateInputDropdown($id, 'filter', $filterlist, -1, $params['filter'], 'id="' . $id . 'filter"') );
$smarty->assign('filterselectjs', '
		$(\'#' . $id . 'filter\').change( function() {
			location.href = "' . str_replace('&amp;','&',$this->CreateLink($id, 'defaultadmin', $returnid, '', array('gbookid' => $gbook_id, 'active_tab' => 'items'), '', true))  . '&' . $id . 'filter="+$(this).val();
		});
');

// entries count based on filter
switch ( $params['filter'] )
{
  case 'showall':
    $entries = $gbooks[$gbook_id]['entries'];
    break;
  case 'active':
    $entries = $gbooks[$gbook_id]['active_entries'];
    break;
  case 'inactive':
    $entries = $gbooks[$gbook_id]['inactive_entries'];
    break;
  case 'spam':
    $entries = $gbooks[$gbook_id]['spam_entries'];
    break;
}
$smarty->assign('filtered_entries', $entries . ' ' . $this->Lang('entries'));



// pagination
$params['gbpage'] = empty($params['gbpage']) ? 1 : $params['gbpage'];
$entries_per_page = 40;
$pages = ceil($entries / $entries_per_page);
$start = (($params['gbpage'] - 1) * $entries_per_page) + 1;

$pagelinks = array();
for ($i = 1; $i <= $pages; $i++) {
	$pagelinks[$i] = $this->CreateLink($id, 'defaultadmin', $returnid, '', array ('gbookid' => $gbook_id, 'gbpage' => $i, 'filter' => $params['filter'], 'active_tab' => 'items'), '', true);
}
$smarty->assign('pagelinks', $pagelinks);
$smarty->assign('currentpage', $params['gbpage']);


$items = Gbook_utils::GetEntries($gbook_id, $start, $entries_per_page, $params['filter']);
foreach ( $items as $key=>$item )
{
	$spamrate = Gbook_utils::b8_exec('Classify', $item->title . ' ' . $item->rawmessage);
	$items[$key]->spamrate = Gbook_utils::format_rating($spamrate);
}
$smarty->assign('items', $items);


$smarty->assign('id', $this->Lang('id'));
$smarty->assign('name', lang('name'));
$smarty->assign('title', lang('title'));
$smarty->assign('content', lang('content'));
//$smarty->assign('ip', lang('ip_addr'));
$smarty->assign('spamrate', $this->Lang('spamrate'));
$smarty->assign('active', lang('active'));
$smarty->assign('create_date', $this->Lang('created'));
$smarty->assign('modified_date', $this->Lang('modified'));
$smarty->assign('approved_date', $this->Lang('approved'));


$smarty->assign('itemcount', count($items));
$smarty->assign('filter', $params['filter']);
$smarty->assign('gbpage', $params['gbpage']);
/*
$smarty->assign('activefalselink', $this->CreateLink($id, 'edititem', $returnid,
				    $admintheme->DisplayImage('icons/system/true.gif', lang('active'),'','','systemicon'),
				    array ('gbookid' => $gbook_id, 'entryid' => 'QQ', 'mode'=>'switchactive', 'filter'=>$params['filter'], 'gbpage'=>$params['gbpage'])));
$smarty->assign('activetruelink', $this->CreateLink($id, 'edititem', $returnid,
				    $admintheme->DisplayImage('icons/system/false.gif', lang('inactive'),'','','systemicon'),
				    array ('gbookid' => $gbook_id, 'entryid' => 'QQ', 'mode'=>'switchactive', 'filter'=>$params['filter'], 'gbpage'=>$params['gbpage'])));
$smarty->assign('editicon', $admintheme->DisplayImage('icons/system/edit.gif', lang ('edit'), '', '', 'systemicon'));
$smarty->assign('editurl', $this->CreateLink($id, 'edititem', $returnid,
				    lang ('edit'),
				    array ('gbookid' => $gbook_id, 'entryid' => 'QQ', 'mode'=>'edit', 'filter'=>$params['filter'], 'gbpage'=>$params['gbpage']), '', true));
$smarty->assign('deletelink', $this->CreateLink($id, 'edititem', $returnid,
					  $admintheme->DisplayImage('icons/system/delete.gif', lang ('delete'), '', '', 'systemicon'),
					  array ('gbookid' => $gbook_id, 'entryid' => 'QQ', 'mode'=>'delete', 'filter'=>$params['filter'], 'gbpage'=>$params['gbpage']), $this->Lang ('areyousure')));
*/
$smarty->assign('multiselect', $this->CreateInputCheckbox($id, 'multiselect[QQ]', 1));

$smarty->assign('formstart', $this->CreateFormStart ($id, 'multiaction', $returnid, 'post', '', false, '', array('gbookid' => $gbook_id, 'filter' => $params['filter'])));
$smarty->assign('formend', $this->CreateFormEnd());

$multiactionlist = array(lang('delete') => 'delete', lang('active') => 'active', lang('inactive') => 'inactive');
$smarty->assign('prompt_multiaction', lang('selecteditems'));
$smarty->assign('multiaction', $this->CreateInputDropdown($id, 'multiaction', $multiactionlist, -1) . ' ' . $this->CreateInputSubmit($id, 'multiactionsubmit', lang('apply'), '', '', $this->Lang('areyousuremulti')) );

/*
$link = $this->CreateLink($id, 'edititem', 0, $admintheme->DisplayImage('icons/system/newobject.gif', $this->Lang('additem'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'edititem', $returnid, $this->Lang("additem"), array("mode"=>"add"), '', false, false, 'class="pageoptions"');
$smarty->assign('addlink', $link);
*/

// Display the populated template
$smarty->display($this->GetTemplateResource('adminitems.tpl'));
?>