<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if (!isset($gCms))
	exit;

// Get gbook properties
$alias = empty($params['alias']) ? $this->GetPreference('defaultgbook') : $params['alias'];
$gbooks = Gbook_utils::GetGbooks($alias);
if (!empty($gbooks))
{
	$gbook = current($gbooks);
	$smarty->assign('gbook_props', $gbook);


	// pagination
	$params['gbpage'] = empty($params['gbpage']) ? 1 : $params['gbpage'];
	$pages = ceil($gbook['entries'] / $gbook['entries_page']);
	$start = (($params['gbpage'] - 1) * $gbook['entries_page']) + 1;


	// get template
	$template = $this->GetPreference('default_summary_template');
	if (!empty($params['template']))
	{
		$template = 'summary_tpl_' . $params['template'];
		$linkparams['template'] = $params['template'];
	}



	// get cache
	$cache_id = '|gb' . md5($gbook['gbook_id'] . '-' . $params['gbpage'] . '-' . $gbook['entries'] . '-' . $gbook['entries_page']);
	if (!$smarty->isCached($this->GetDatabaseResource($template), $cache_id))
	{
		// get gbook entries
		$entries = Gbook_utils::GetEntries($gbook['gbook_id'], $start, $gbook['entries_page']);
		$smarty->assign('gbook_entries', $entries);

		// pagination links
		$prettyurl = 'gbook/' . $gbook['gbook_id'] . '-';
		$linkparams['alias'] = $gbook['gbook_id'];
		$pagelinks = array();
		for ($i = 1; $i <= $pages; $i++)
		{
			$linkparams['gbpage'] = $i;
			$pagelinks[] = $this->CreateFrontendLink($id, $returnid, 'default', '', $linkparams, '', true, true, '', false); //, $prettyurl . $i . '/' . $returnid);
		}
		$smarty->assign('gbook_pagelinks', $pagelinks);
		$smarty->assign('gbook_currentpage', $params['gbpage']);
		$smarty->assign('gbook_entrieslabel', $this->Lang('entries'));
		$smarty->assign('gbook_ratingslabel', $this->Lang('rating'));
	}

	// Display template
	echo $smarty->fetch($this->GetDatabaseResource($template), $cache_id);
}

?>