<?php

if (!isset($gCms)) exit;
if(! $this->CheckPermission( 'Use TruetypeText' ) ) exit;

if (!isset($params['styleid']) || isset($params['back']))
	$this->Redirect($id, 'defaultadmin', $returnid);

$errors = array();

include_once cms_join_path(dirname(__FILE__),'class.style.php');

$styleid = $params['styleid'];
$count_elements =  $params['count_elements'];

$fonts = $this->getfonts();

$elements = array();
for ($i = 0; $i < $count_elements; $i++)
{
	$element = array();
	$element[0] = $params['element_'.$i.'_type'];
	switch ($element[0])
	{
		case 'text' :
			$element[1] = $params['element_'.$i.'_fontfile'];
			$element[2] = $params['element_'.$i.'_size'];
			
			$color = $params['element_'.$i.'_color'];
			if (strlen($color)!=7) $errors[] = $this->lang('error_colorformat');
			
			$transparency = $params['element_'.$i.'_transparency'];
			if (!is_numeric($transparency)) $errors[] = $this->lang('error_transparency');
			$transparency = min(max(0,$transparency),100);
			if ($transparency == 0) $transparency = '';
			else $transparency = str_pad(strtoupper(dechex(round($transparency/100*255))),2,'0',STR_PAD_LEFT);
			
			$element[3] = $color.$transparency;
			
			$element[4] = $params['element_'.$i.'_deltax'];
			$element[5] = $params['element_'.$i.'_deltay'];
			$element[6] = $params['element_'.$i.'_angle'];
			
			if (!in_array($element[1], $fonts)) $errors[] = $this->lang('error_unknownfont').' : '.$element[1];
			if (!is_numeric($element[2]) || $element[2]<=0) $errors[] = $this->lang('error_size');
			if (preg_match('/^#?([A-F0-9]{6})$/i', $color)==0) $errors[] = $this->lang('error_colorformat').$element[3] ;
			if (!is_numeric($element[4])) $errors[] = $this->lang('error_delta');
			if (!is_numeric($element[5])) $errors[] = $this->lang('error_delta');
			if (!is_numeric($element[6])) $errors[] = $this->lang('error_angle');
			break;

		case 'mirror' :
			$element[1] = $params['element_'.$i.'_ratio'];
			$element[2] = $params['element_'.$i.'_upopacity'];
			$element[3] = $params['element_'.$i.'_downopacity'];
			
			if (!is_numeric($element[1]) || $element[1]<=0) $errors[] = $this->lang('error_ratioinvalid');
			if (!is_numeric($element[2])) $errors[] = $this->lang('error_transparency');
			if (!is_numeric($element[3])) $errors[] = $this->lang('error_transparency');
			
			$element[2] = min(100, max(0, $element[2]));
			$element[3] = min(100, max(0, $element[3]));
			
			break;
		case 'effect' :
			$element[1] = $params['element_'.$i.'_filtertype'];
			break;
		default :
			$errors[] = $this->lang('error_unknownelementtype').' : '.$element[0];
	}
	$elements[] = $element;
}
if (count($elements)==0) $errors[] = $this->lang('error_noelement');

$TTTstyle = new TTTstyle();
$TTTstyle->loaddb($styleid);
$TTTstyle->elements = $elements;

$newparams = array('styleid' => $styleid, 'active_tab' => 'elements');

if (count($errors)==0)
{
	if (!$TTTstyle->updatedb())
		$errors = $this->lang('error_unabletosavestyle');
	else
		$newparams['module_message'] = $this->lang('stylesaved');
}

if (count($errors)>0) $newparams['module_error'] = implode('<br />', $errors);
$this->Redirect($id, 'editstyle', $returnid, $newparams);





?>