{if isset($error)}<strong>{$error}</strong>{/if}
<h3>{$rdmap->title}</h3>
<div id="map{$rdmap->map_id}" style="height: 400px">
</div>
<script type="text/javascript">
var basemap_url = "{$rdmap->basemap}";
var overlay_url = "{$rdmap->overlay}";
var initial_extent = "{$rdmap->initial_extent}";
var overlay_parameters = "{$rdmap->overlay_parameters}";
{literal}
function createPopup(geojson,layer) {
	if (geojson.properties) {
		var popupText = "<div style='overflow-y:scroll; max-height:200px;'>";
		for (prop in geojson.properties) {
			var val = geojson.properties[prop];
			if (val && prop !== "globalid" && !prop.match(/objectid_\d+/)) {
				popupText += "<b>" + prop + "</b>:" + val + "<br/>";
			}
		}
		popupText += "</div>";
		layer.bindPopup(popupText);
	}
}

function processParams(overlay_params) {
	var terms = overlay_params.split(';');
	var out_terms = new Object();
	for(i=0;i<terms.length;i++) {
		var t = terms[i];
		var key = t.slice(0,t.indexOf('='));
		var val = t.slice(t.indexOf('=') + 1,t.length);
		out_terms[key] = val;
	}
	return out_terms;
}

var x = initial_extent.split('/')[0];
var y = initial_extent.split('/')[1];
var zoom = initial_extent.split('/')[2];
{/literal}
var map = L.map('map{$rdmap->map_id}').setView([y,x],zoom);
{literal}
L.tileLayer(basemap_url + '/tile/{z}/{y}/{x}', {
	maxzoom: 19 }).addTo(map);
if (overlay_url !== null) {
	var esriparams = { onEachFeature: createPopup };
	if (overlay_parameters !== null) {
		var params = processParams(overlay_parameters);
		for (key in params) {
			esriparams[key] = params[key];
		}
	}
	layerFS = L.esri.featureLayer(overlay_url, esriparams).addTo(map);
}

{/literal}
</script>
