<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Module upgrade
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/


	if (!isset($gCms)) exit;

	$current_version = $oldversion;
	switch($current_version) {
		case "0.0.1": {
			$db = cmsms()->GetDb();
			$taboptarray  =array('mysql' => 'ENGINE=MyISAM');
			$dict = NewDataDictionary($db);
			$flds = "template_id I AUTO KEY,
			name C(80) NOTNULL,
			code X NOTNULL
			";
			$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_rdmap_templates", $flds, $taboptarray);
			if (!$dict->ExecuteSQLArray($sqlarray)) {
				$this->Audit(1, $this->Lang('friendlyname'), $this->Lang('upgrade_failed'));
				return;
			}

			$flds =  "
				template_id I CONSTRAINTS 'FOREIGN KEY REFERENCES".cms_db_prefix()."module_rdmap_templates'";

			$sqlarray = $dict->AddColumnSQL(cms_db_prefix()."module_rdmap", $flds);
			if (!$dict->ExecuteSQLArray($sqlarray)) {
				$this->Audit(1, $this->Lang('friendlyname'), $this-Lang('upgrade_failed'));
				return;
			}

			break;
		}
		case "0.0.2": {
			$db = cmsms()->GetDb();
			$taboptarray  =array('mysql' => 'ENGINE=MyISAM');
			$dict = NewDataDictionary($db);
			$q = $dict->DropColumnSQL(cms_db_prefix().'module_rdmap', 'template_id');
			$dict->ExecuteSQLArray($q);

			$q = $dict->DropTableSQL(cms_db_prefix().'module_rdmap_templates');
			$dict->ExecuteSQLArray($q);

			$q = $dict->AddColumnSQL(cms_db_prefix().'module_rdmap', "template_name C(80) NOTNULL");
			$dict->ExecuteSQLArray($q);
		}
        default: {
            $db = cmsms()->GetDb();
            $sql = "SELECT COUNT(*) as cnt from information_schema.columns where table_name = 'cms_module_rdmap' and column_name = 'overlay_parameters";
            $result = $db->GetRow($sql);
            if ($result['cnt'] == 0) {
                // missing the overlay_parameters field
                $dict = NewDataDictionary($db);
                $taboptarray = array('mysql' => 'ENGINE=MyISAM');
                $fld = "overlay_parameters C(256)";
                $q = $dict->AddColumnSQL(cms_db_prefix()."module_rdmap", $fld, $taboptarray);
                if (!$dict->ExecuteSQLArray($q)) {
                    $this->Audit(1, $this->Lang('friendlyname'), $this->Lang('upgrade_failed'));
                }
            }
        }
	}
	$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded'));
?>
