<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Module installer
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/


if (!function_exists('cmsms')) exit;

$this->CreatePermission('Use RD Map','Use RD Map');
$this->CreatePermission('Set RD Map Prefs', 'Set RD Map Prefs');

$db = cmsms()->GetDb();

// mysql-specific, but ignored by other database
$taboptarray = array( 'mysql' => 'ENGINE=MyISAM' );

$dict = NewDataDictionary( $db );

// table schema description
$flds = "
    map_id I AUTO KEY,
	name C(80) NOTNULL,
	title C(256),
    basemap C(256) NOTNULL,
	overlay C(256),
    overlay_parameters C(256),
    initial_extent C(64),
	template_name C(80) NOTNULL
";
                        
// create it. This should do error checking, but I'm a lazy sod.
$sqlarray = $dict->CreateTableSQL( cms_db_prefix()."module_rdmap",
        $flds, 
        $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL('i_name', cms_db_prefix()."module_rdmap", 'name');
$ret = $dict->ExecuteSQLArray($sqlarray);
if ($ret === 0) {
	throw new Exception("failed to create index");
}

$this->SetPreference('default_basemap','http://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer');
$this->SetPreference('initial_extent','0/0/2');
$this->CreateEvent('OnRDMapPreferenceChange');
$this->Audit( 0,
	$this->Lang('friendlyname'),
	$this->Lang('installed'), $this->GetVersion());

// register event handlers
$this->AddEventHandler('Core','ContentPostRender',false);
?>
