<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/


$lang['add_map'] = 'Add Map';
$lang['add_template'] = 'Add Template';
$lang['copy_map'] = 'Copy Map';
$lang['copy_template'] = 'Copy Template';
$lang['delete_map'] = 'Delete Map';
$lang['delete_template'] = 'Delete Template';
$lang['edit_map'] = 'Edit Map';
$lang['edit_template'] = 'Edit Template';
$lang['error_map_no_name'] = 'The map must have name';
$lang['error_template_no_name'] = 'The template must have a name';
$lang['cancel'] = 'Cancel';
$lang['field_map_id'] = 'Map ID';
$lang['field_map_title'] = 'Title';
$lang['field_map_name'] = 'Name';
$lang['field_map_basemap'] = 'Basemap';
$lang['field_map_overlay'] = 'Overlay Map';
$lang['field_map_initial_extent'] = 'Initial Extent';
$lang['field_template_id'] = 'Template ID';
$lang['field_template_name'] = 'Name'; 
$lang['friendlyname'] = 'RD Map';
$lang['help'] = '<h3>What is this thing?</h3>
<p>The RD Map module can display a map on a page. That\'s about it, really. A map has a basemap layer, and can have an overlay layer.</p><h3>How Do I Use It?</h3>
<p>When editing a page (or template), place the {Map} tag somewhere. The map tag has one required argument, that of the name of the map to include, like so: <tt>{Map&nbsp;name=&lt;map_name&gt;}</tt>.</p>
<h3>Creating Maps</h3><p>
So far, the default map template requires an ArcGIS tiled map service for a basemap, and an ArcGIS feature service for the overlay map. The map templates are completely customizable, however.
<h4>Map Names and Titles</h4>
<p>The map name is a handy name that the site administrator can use to reference the map on the pages where it appears. The site users should never see it. The map title shows up in the default template right above the map.
</p><h4>Basemaps</h4><p>The basemap should be the URL to the service that provides the raster basemap tiles. By default this is ArcGIS Server, and should be the URL right up to (and including) the MapServer part. Any other kind of basemap service will require a customized template to support.</p>
<h4>Initial Map Extent<h4><p>
The initial map extent setting determines where the centre of the map and the zoom level as the map loads. The extetnt should be formatted as <tt>lat/long/zoom</tt>, where <tt>lat</tt> and <tt>long</tt are in decimal degrees, and the <tt>zoom</tt> is an integer between 1 and 20.</p>
<h4>Map Overlay and Overlay Parameters</h4><p>
With the default template, the map overlay is treated as an ArcGIS REST FeatureServer layer. Other services are possible (as usual) with a customized template. The optional overlay parameters are extra query parameters to be added on to every request to the server, and might be something like</p>
<pre>where=NAME LIKE "STATION"</pre>
<p>For the default template, the only currently supported parameters are <tt>where</tt> and <tt>token</tt>.
<p>Multiple parameters can be separated by semicolons.
</p>';
$lang['help_name'] = 'The name of the map to be placed on the page. This name won\'t show up anywhere the site users can see, and can\'t have any spaces or special characters.';
$lang['help_map_basemap'] = 'Url to the tiling map service that serves as the basemap';
$lang['help_map_extent'] = 'The initial extent of the map, given in the form of longitude/latitude/zoom. Lat/long are in decimal degrees, and mark the centre of the map. The Zoom parameter is a number between 0 and 19.';
$lang['help_map_name'] = 'The name is used by the {Map} tag and should contain no spaces or punctuation.';
$lang['help_map_overlay'] = 'Url to the overlay map. This should be a feature service that can be queried for attributes.';
$lang['help_map_overlay_parameters'] = 'Additional parameters to include when querying for overlay features. The typical use would be a ArcGIS REST where clause.';
$lang['help_map_title'] = 'The title of the map that will show up on the page.';
$lang['help_template'] = 'The template for the map. Templates can be customised to completely redesign look and function of the map.';
$lang['help_template_name'] = "The name of the template. Make this descriptive enough that it\'s easy to identify when creating a map.";
$lang['help_template_code'] = 'The code that describe the look and behaviour of the map';
$lang['installed'] = 'installed';
$lang['map_name_not_set'] = 'Map error: the map name was not set';
$lang['error_map_not_found'] = 'The map was not found';
$lang['submit'] = 'Submit';
$lang['title_basemap'] = 'Basemap';
$lang['title_default_basemap'] = 'Default Basemap';
$lang['title_default_extent'] = 'Default Map Extents';
$lang['title_initial_extent'] = 'Initial Map Extent';
$lang['title_input_default_basemap_help'] = 'Set the default basemap url';
$lang['title_general'] = 'General';
$lang['title_maps'] = 'Maps';
$lang['title_map_name'] = 'Name';
$lang['title_map_title'] = 'Title';
$lang['title_overlay'] = 'Map Overlay';
$lang['title_overlay_parameters'] = 'Map Overlay Additional Parameters';
$lang['title_prefs'] = 'Preferences';
$lang['title_template_name'] = 'Map Template';
$lang['title_template_code'] = 'Template Code';
$lang['title_templates'] = 'Templates';
$lang['uninstalled'] = 'uninstalled';
$lang['upgrade_failed'] = 'Upgrade failed';
$lang['welcome_text'] = '<p>This is the RD Maps module. Place it on a page with the {Map name=&lt;map_name&gt;} tag.</p>';
?>
