<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Process the page post-render. Specifically, add the leaflet JS scripts and
 * CSS to the page.
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

if (!isset($gCms)) exit;
$mod = cms_utils::get_module('RDMap');

$smarty = cmsms()->GetSmarty();
$tpl_vars = $smarty->get_template_vars();
if (strpos($tpl_vars['main_content'], 'L.map(') !== false)
{
$content = $params['content'];
$detail_keywords = '';

// Get the head section of the document

$headstart = strpos($content,'<head>');
$headend   = strpos($content,'</head>');
$headlength = $headend - $headstart;
$headcontent = substr($content,$headstart,$headlength);

// css file
if (preg_match("/\s*<link.*leaflet.css/", $headcontent)) {
	$headcontent .= '<!-- RD Map module found another leaflet css file here. Remove it from the template to use the one included by the Map module\n -->';
}
else {
	$headcontent .= "<link rel=\"stylesheet\" href=\"http://cdn.leafletjs.com/leaflet-0.7.2/leaflet.css\" />\r\n";
}

// javascript files
if (preg_match('/\s*<script.*\/leaftlet.js/',$headcontent)) {
	$headcontent .= "<!-- RD Map module found another leaflet.js file included. Remove it from the template to use the one included by the Map module. -->\n";
}
else {
	$headcontent .= "\t<script src=\"http://cdn.leafletjs.com/leaflet-0.7.2/leaflet.js\"></script>\r\n";
}
if (preg_match('/s*<script.*esri-leaflet.js/', $headcontent)) {
	$headcontent .= "<!-- RD Map module found another esri-leaflet.js file included. Remove it from the template to use the one included by the Map module. -->\n";
} else {
	$headcontent .= "\t<script src=\"".$this->GetModuleUrlPath()."/lib/js/esri-leaflet/esri-leaflet-src.js\"></script>\r\n";
}


$content = substr_replace($content,$headcontent,$headstart,$headlength);

$params['content'] = $content;
}
?>
