<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Save changes to a map
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/
if (!isset($gCms)) exit;

if (isset($params['cancel'])) {
	$this->RedirectToAdminTab('maps');

} else if (isset($params['submit'])) {
	if (isset($params['map_id']) && $params['map_id'] !== '' ) {
		$map = map_operations::get_map_by_id($params['map_id']);
	} else {
		$map = new rdffg_map;
	}

    if (!isset($params['name']) || strlen($params['name']) == 0 || is_null($params['name'])) {
        $params['error'] = $this->Lang('error_map_no_name');
        $this->Redirect($id, 'admin_add_map', $returnid, $params);
    }

	$map->name = $params['name'];
	$map->title = $params['title'];
	$map->basemap = $params['basemap'];
	$map->overlay = $params['overlay'];
    $map->overlay_parameters = $params['overlay_parameters'];
	$map->initial_extent = $params['initial_extent'];
	$map->template_name = $params['template_name'];
	map_operations::save_map($map);

} else {
	// error condition?
}
	$this->RedirectToAdminTab('maps');

?>
