<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Delete a map from the database
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

if (!isset($gCms)) exit;

if (!isset($params['map_id'])) {
	$this->FireDebug('error','map id not set'); 
	$this->RedirectToAdminTab('maps');
}

try {
	$map = map_operations::get_map_by_id($params['map_id']);
}
catch (Exception $e) {
	$this->FireDebug('warning', 'Failed to get map '.$params['map_id'].' from the database');
	$this->RedirectToAdminTab('maps');
}

map_operations::delete_map($map);
$this->RedirectToAdminTab('maps');

?>
