<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Main admin panel
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

if (!isset($gCms)) exit;

if (FALSE == empty($params['active_tab'])) {
	$tab = $params['active_tab'];
} else {
	$tab = '';
}

$tab_header = $this->StartTabHeaders() .
	$this->SetTabHeader('general', $this->Lang('title_general'),('general' == $tab)?true:false) .
	$this->SetTabHeader('preferences', $this->Lang('title_prefs'),('preferences' == $tab)?true:false).
	$this->SetTabHeader('maps', $this->Lang('title_maps'), ('maps' == $tab)?true:false).
	$this->SetTabHeader('templates', $this->Lang('title_templates'), ('templates' == $tab)?true:false).
    $this->EndTabHeaders();

$this->smarty->assign('tabs_start', $this->StartTabContent());
$this->smarty->assign('start_general_tab',$this->StartTab('general',$params));
$this->smarty->assign('start_preference_tab', $this->StartTab('preferences', $params));
$this->smarty->assign('start_maps_tab', $this->StartTab('maps', $params));
$this->smarty->assign('start_templates_tab', $this->StartTab('templates', $params));

$this->smarty->assign('tab_headers', $tab_header);
$this->smarty->assign('tab_end',$this->EndTab());
$this->smarty->assign('tabs_end',$this->EndTabContent());

// module defaults form
$this->smarty->assign('start_form', $this->CreateFormStart($id, 'save_admin_prefs', $returnid));

// default basemap
$this->smarty->assign('title_basemap', $this->Lang('title_default_basemap',''));
$this->FireDebug('info','Basemap: '.$this->GetPreference('default_basemap',''));
$this->smarty->assign('input_basemap', $this->CreateInputUrl($id,'basemap', $this->GetPreference('default_basemap',''), 96));

// initial extents
$this->smarty->assign('title_extent', $this->Lang('title_default_extent',''));
$this->smarty->assign('input_extent', $this->CreateInputText($id, 'initial_extent', $this->GetPreference('initial_extent',''), 96));
$this->smarty->assign('submit',$this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$this->smarty->assign('welcome_text',$this->Lang('welcome_text'));

// maps page
$this->smarty->assign('map_id', $this->Lang('field_map_id'));
$this->smarty->assign('map_name', $this->Lang('field_map_name'));
$this->smarty->assign('map_basemap', $this->Lang('field_map_basemap'));
$this->smarty->assign('map_overlay', $this->Lang('field_map_overlay'));
$this->smarty->assign('map_initial_extent', $this->Lang('field_map_initial_extent'));
$this->smarty->assign('maps_template', __DIR__.'/templates/adminmaps.tpl');
$this->smarty->assign('templates_template', __DIR__.'/templates/admintemplates.tpl');
$this->smarty->assign('field_template_name', $this->Lang('field_template_name'));
$this->smarty->assign('field_template_id', $this->Lang('field_template_id'));

$maplist = map_operations::get_maps();

foreach ($maplist as $map) {
	$map->edit_link = $this->CreateImageLink($id, 'admin_add_map', $returnid, $this->Lang('edit_map'),
			 'icons/system/edit.gif','',
			array('map_id'=>$map->map_id));
    $map->copy_link = $this->CreateImageLink($id, 'admin_copy_map', $returnid, $this->Lang('copy_map'),
            'icons/system/copy.gif', '',
            array('map_id'=>$map->map_id));
	$map->delete_link = $this->CreateImageLink($id, 'delete_map', $returnid, $this->Lang('delete_map'),
			'icons/system/delete.gif','',
			array('map_id'=>$map->map_id));
	$map->map_link = $this->CreateLink($id, 
		'admin_add_map', 
		$returnid, 
		$map->name, 
		array('map_id'=>$map->map_id));
			
}

$this->smarty->assign('maplist', $maplist);
$this->FireDebug('info', 'Found '.count(map_operations::get_maps()).' maps.');
$this->smarty->assign('add_map', $this->CreateImageLink($id,'admin_add_map',$returnid, '', 'icons/system/newobject.gif',$this->Lang('add_map')));

// templates page
$this->smarty->assign('template_id', $this->Lang('field_template_id'));
$this->smarty->assign('template_name', $this->Lang('field_template_name'));
$this->smarty->assign('template_code', $this->Lang('field_template_code'));
$template_names = $this->ListTemplates();
$template_list = array();

foreach($template_names as $template_name) {
	$template = new rdffg_template;
	$template->name = $template_name;
	$template->edit_link = $this->CreateLink($id,
		'admin_add_template',
		$returnid,
		$template->name,
		array('template_name'=>$template->name));
	$template->edit_imagelink = $this->CreateImageLink($id, 
		'admin_add_template', 
		$returnid, $this->Lang('edit_template'),
		'icons/system/edit.gif','',
		array('template_name'=>$template->name));
    $template->copy_link = $this->CreateImageLink($id,
        'admin_copy_template',
        $returnid, $this->Lang('copy_template'),
        'icons/system/copy.gif','',
        array('template_name'=>$template->name));
	$template->delete_link = $this->CreateImageLink($id, 
		'admin_delete_template', 
		$returnid, $this->Lang('delete_template'),
		'icons/system/delete.gif','',
		array('template_name'=>$template->name));
	$template_list[] = $template;
}

$this->FireDebug('info','$id is: '.$id.', and $returnid is: '.$returnid);

$this->smarty->assign('templatelist', $template_list);
$this->smarty->assign('add_template', $this->CreateImageLink($id, 'admin_add_template', $returnid,
	'',
	'icons/system/newobject.gif',
	$this->Lang('add_template')));

if (isset($params['error'])) {
	$this->smarty->assign('error_msg', $params['error']);
}

echo $this->ProcessTemplate('adminpanel.tpl');
?>
