<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Add a map to the database
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

if (!isset($gCms )) exit;

$smarty = $this->smarty;

if (! $this->GetPreference('allow_add',1) == 1) exit;

$db = $gCms->GetDb();

if (isset($params['map_id'])) {
		$map = map_operations::get_map_by_id($params['map_id']);
} else {
	$map = new rdffg_map;
}
$this->FireDebug('info','overlay '.$map->overlay.' and parameters: '.$map->overlay_parameters);

// populate the map object from the previous form
if (isset($params['name'])) $map->name = $params['name'];
if (isset($params['title'])) $map->title = $params['title'];
if (isset($params['basemap'])) $map->basemap = $params['basemap'];
if (isset($params['overlay'])) $map->overlay = $params['overlay'];
if (isset($params['overlay_parameters'])) $map->overlay_parameters = $params['overlay_parameters'];
if (isset($params['template'])) $map->template = $params['template'];

$template_names = $this->ListTemplates();
$templates = array();
// add the file based default template
$templates['default'] = 'default';
foreach ($template_names as $t) {
	$templates[$t] = $t;
}

// wipe out the map id if we are creating a copy of the map
if (array_key_exists('copy_map', $params)) {
    $map->map_id = null;
    $map->name = null;
}

if (isset($params['error'])) {
    $smarty->assign('error', $params['error']);
}

$smarty->assign('start_form', $this->CreateFormStart($id, 'save_map', $returnid));

$smarty->assign('name', $this->CreateInputText($id, 'name', $map->name, 96));
$smarty->assign('title_name', $this->Lang('title_map_name'));
$smarty->assign('title', $this->CreateInputText($id, 'title', $map->title, 96));
$smarty->assign('title_title', $this->Lang('title_map_title'));
$smarty->assign('basemap', $this->CreateInputText($id, 'basemap', $map->basemap, 96));
$smarty->assign('title_basemap', $this->Lang('title_basemap'));
$smarty->assign('title_extent', $this->Lang('title_initial_extent'));
$smarty->assign('overlay', $this->CreateInputText($id, 'overlay', $map->overlay, 96));
$smarty->assign('title_overlay', $this->Lang('title_overlay'));
$smarty->assign('overlay_parameters', $this->CreateInputText($id, 'overlay_parameters', $map->overlay_parameters, 96));
$smarty->assign('title_overlay_parameters', $this->Lang('title_overlay_parameters'));
$smarty->assign('initial_extent', $this->CreateInputText($id, 'initial_extent', $map->initial_extent, 96));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
$smarty->assign('map_id', $this->CreateInputHidden($id, 'map_id', $map->map_id));
$smarty->assign('help_name', $this->Lang('help_map_name'));
$smarty->assign('help_title', $this->Lang('help_map_title'));
$smarty->assign('help_basemap', $this->Lang('help_map_basemap'));
$smarty->assign('help_extent', $this->Lang('help_map_extent'));
$smarty->assign('help_overlay', $this->Lang('help_map_overlay'));
$smarty->assign('help_overlay_parameters', $this->Lang('help_map_overlay_parameters'));
$smarty->assign('help_template_name', $this->Lang('help_template'));
$smarty->assign('title_template_name', $this->Lang('title_template_name'));
$smarty->assign('templates', $this->CreateInputDropdown($id, 'template_name', $templates, -1, $map->template_name));
echo $this->ProcessTemplate('edit_map.tpl');
?>
