<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * RDMap module: place a customizable map on a page.
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

class RDMap extends CMSModule {
	function GetName() {
		return 'RDMap';
	}

	function GetFriendlyName() {
		return $this->Lang('friendlyname');
	}

	function GetVersion() {
		return '0.5.0';
	}

	function GetHelp() {
		return $this->Lang('help');
	}

	function IsPluginModule() {
		return true;
	}

	function HasAdmin() {
		return true;
	}

	function GetAdminSection() {
		return 'extensions';
	}

	function VisibleToAdminUser() {
		return $this->CheckPermission('Use RD Map');
	}

	function GetDashboardOutput() {
		return '';
	}

	function GetDependencies() {
		return array();
	}

	function MinimumCMSVersion() {
		return '2.0';
	}

	function MaximumCMSVersion() {
		return '2.2.7';
	}

	function SetParameters() {
		$this->RegisterModulePlugin();
		$this->RestrictUnknownParams();
		$this->CreateParameter('name', '', $this->Lang('help_name'));
		$this->SetParameterType('name',CLEAN_STRING);

	}

	function GetHeaderHTML() {
		$this->FireDebug('info','Header text: '.$this->_out_header_html());
		return $this->_out_header_html();
	}

	protected function _out_header_html() {
		$out = '<link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet-0.6.4/leaflet.css" />';
		$out .= '<script src="http://cdn.leafletjs.com/leaflet-0.6.4/leaflet.js"></script>';
		return $out;
	}

	function FireDebug($command, $message, $variables=array()) {
		$firephpmodule=$this->GetModuleInstance('FirePHPDebug');
		if($firephpmodule) {
			$firephpmodule->SetModuleName($this->GetName());
			$firephpmodule->Command($command, $message, $variables);
		}
	}

	function CreateImageLink($id, $action, $returnid, $title, $imagepath, $addtext='', $params = null) {
		return $this->CreateLink($id, $action, $returnid, CmsAdminThemeBase::GetThemeObject()->DisplayImage($imagepath).$addtext, $params, '', false, false, 'title='.$title);
	}
}
?>
