<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$entry_id = $params['entryid'];
if ( $entry_id == -1 )
{
	// get latest entry
	
	// but fist we need the gbook properties
	$alias = empty($params['alias']) ? $this->GetPreference('defaultgbook') : $params['alias'];
	$gbooks = Gbook_utils::GetGbooks($alias);
	$gbook = $gbooks[0];

	$entries = Gbook_utils::GetEntries($gbook['gbook_id'], 1, 1);
	$entry = empty($entries) ? '' : $entries[0];
}
else
{
	$entry = Gbook_utils::GetEntry($entry_id);
}

if ( !empty($entry) )
{
	$smarty->assign('gbook_entry', $entry);

	// get template
	$template = $this->GetPreference('default_detail_template');
	if (!empty($params['template']))
	{
		$template = 'detail_tpl_' . $params['template'];
	}
/*
	global $CMS_VERSION;
	if ( $CMS_VERSION >= '1.11' )
	{
		// clear cache for this template
		$smarty->clearCache($this->GetDatabaseResource($template));
	}
 */
	echo $this->ProcessTemplateFromDatabase($template);
}

?>