<?php
#-------------------------------------------------------------------------------
#
# Module : Losungen (c) 2011-2014 by blattertech informatik (info@blattertech.ch)
#          Herrnhuter Losungen fr CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/losung/
#          CMS Made Simple is (c) 2004-2011 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 1.4
# File   : action.default.php
# Purpose: Ausgabe der Losungen
# License: GPL
#
#-------------------------------------------------------------------------------

// Check authorisation
if(!is_object(cmsms())) exit;

//include_once (realpath(dirname(__FILE__) ."/lib/class.Losung.php"));

$datum = getdate();

$smarty = cmsms()->GetSmarty();

#Losung einlesen
$filename = realpath(dirname(__FILE__) ."/losungen/losungen" . $datum['year'] . ".xml");
if (!file_exists($filename))
{
	echo "<p>Die Losungen von diesem Jahr sind noch nicht da. Ein Update k&ouml;nnte helfen.</p>";
	return;
}

$xml = simplexml_load_file($filename);
$Losung = $xml->Losungen[ $datum['yday'] ];
if (is_null($Losung))
{
	echo "<p>Komischer Fehler: Konnte keine Losungsverse für diesen Tag finden.</p>";
	return;
}

$losung = new StdClass();

$l->datum = $datum['mday']. "." . $datum['mon']. "." . $datum['year'];
$l->losungstext = $Losung->Losungstext;
$l->losungsvers = $Losung->Losungsvers;
$l->losungsverslink = 'http://www.bibleserver.com/go.php?lang=de&amp;bible=LUT&amp;ref=' . urlencode($Losung->Losungsvers);
$l->lehrtext = $Losung->Lehrtext; 
$l->lehrvers = $Losung->Lehrtextvers;
$l->lehrverslink = 'http://www.bibleserver.com/go.php?lang=de&amp;bible=LUT&amp;ref=' . urlencode($Losung->Lehrtextvers);
$l->copyright = '<a href="http://www.ebu.de" target="_blank" title="Evangelische Br&uuml;der-Unit&auml;t">&copy; Evangelische Br&uuml;der-Unit&auml;t – Herrnhuter Br&uuml;dergemeinde</a> <br> <a href="http://www.losungen.de" target="_blank" title="www.losungen.de">Weitere Informationen finden Sie hier</a>';
	

$smarty->assign("losung",$l);
echo $this->ProcessTemplateFromDatabase("losungen");


return '';

// EOF