<?php
#-------------------------------------------------------------------------------
#
# Module : Losungen (c) 2011-2014 by blattertech informatik (info@blattertech.ch)
#          Herrnhuter Losungen fr CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/losung/
#          CMS Made Simple is (c) 2004-2011 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 1.4
# File   : Losungen.module.php
# Purpose: initial module class. this is the interface to the Module API
# License: GPL
#
#-------------------------------------------------------------------------------

class Losungen extends CMSModule
{
	private $config;

	public final function GetName() 					{	return 'Losungen';	}

	public final function GetFriendlyName()				{ 	return $this->Lang('friendly_name');	}

	public final function GetVersion()					{	return '1.4';	}

	public final function GetHelp() 					{	return $this->Lang('help');	}

	public final function GetAuthor()					{	return 'blattertech informatik'; }

	public final function GetAuthorEmail()				{	return 'info@blattertech.ch';	}

	public final function IsPluginModule()				{	return true;	}
		
	public final function GetDependencies() 			{	return array(); }
	
	public final function IsAdminOnly() 				{	return false;	}

	public final function HasAdmin()					{	return true;	}

	public final function GetAdminSection()				{	return 'content'; }

	public final function GetAdminDescription()			{	return $this->Lang('moddescription');	}

	public final function VisibleToAdminUser()			{	return $this->CheckPermission('Use Losungen');	}

	public final function MinimumCMSVersion()			{	return "1.12";	}

	//public final function MaximumCMSVersion()			{	return "";	}

	public final function InstallPostMessage()			{	return $this->Lang('postinstall');	}

	public final function UninstallPostMessage()		{	return $this->Lang('postuninstall'); }

	public final function UninstallPreMessage()			{	return $this->Lang('really_uninstall');	}
	
	public final function SetParameters() 
	{
		$this->RegisterModulePlugin();
		$this->RestrictUnknownParams();
	}
	
	public final function InitializeAdmin() 			{  $this->SetParameters();	}

	public final function LazyLoadFrontend()			{  return false; }
	
	public final function InitializeFrontend() 			{	$this->SetParameters();	}
}