<?php
#-------------------------------------------------------------------------
# Album - Photo Albums
# Version 1.11
# This module allows you to add photo albums to your website
# maintained by Fernando Morgado AKA Jo Morg
# since 2013
#-------------------------------------------------------------------------
#
# Previously maintained by:
# dam & Elijah Lofgren <elijahlofgren@elijahlofgren.com>
#
#-------------------------------------------------------------------------
#
# Album is a CMS Made Simple module that enables the web developer to 
# add photo albums to a website
#
#-------------------------------------------------------------------------
# BEGIN_LICENSE
#-------------------------------------------------------------------------
# This file is part of Album
# Album program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Album program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
# END_LICENSE
#-------------------------------------------------------------------------
if( !defined('CMS_VERSION') ) exit;
/**
 * @see Album.module.php
 * @see class Album
*/
// Typical Database Initialization
$db = cmsms()->GetDb();

// mysql-specific, but ignored by other database
$taboptarray = array('mysql' => 'TYPE=MyISAM');
$dict = NewDataDictionary($db);

// table schema description
$flds = "
	album_id I KEY,
	album_name C(80),
	album_number I,
	thumbnail_path C(255),
	comment X,
	template C(50)
	";

// create it. This should do error checking, but I'm a lazy sod.
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_album_albums",
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// create a sequence
$db->CreateSequence(cms_db_prefix()."module_album_albums_seq");

//create Index on albumtable
$flds = "
	album_number
	";
  
$sqlarray = $dict->CreateIndexSQL(cms_db_prefix()."module_album_albums_index", cms_db_prefix()."module_album_albums",$flds);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
	picture_id I KEY,
	picture_name C(80),
	picture_album_id I,
	picture_number I,
	thumbnail_path C(255),
	picture_path C(255),
	comment X,
	comment2 X,
	comment3 X,
      	thumbnail_width C(20),
      	thumbnail_height C(20)
	";

// create it. This should do error checking
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_album_pictures",
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// create a sequence
$db->CreateSequence(cms_db_prefix()."module_album_pictures_seq");

//create Index on picture table
$flds = "
	picture_album_id,
	picture_number
	";
$sqlarray = $dict->CreateIndexSQL(cms_db_prefix()."module_album_pictures_index", cms_db_prefix()."module_album_pictures",$flds);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
        template_name C(255) KEY,
        metadata X,
        info     X
        ";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_album_templateextra",
				  $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// permissions
$this->CreatePermission('Use Album','Use Album');

// give Admin and Editor group rights to 'Use Album'
// There is a function request to put this all in one function like:
$perm_id = $db->GetOne("SELECT permission_id FROM ".cms_db_prefix()."permissions WHERE permission_name = 'Use Album'");
$group_id = $db->GetOne("SELECT group_id FROM ".cms_db_prefix()."groups WHERE group_name = 'Admin'");

$count = $db->GetOne("SELECT count(*) FROM " . cms_db_prefix() . "group_perms WHERE group_id = ? AND permission_id = ?", array($group_id, $perm_id));
if (isset($count) && intval($count) == 0)
{
	$new_id = $db->GenID(cms_db_prefix()."group_perms_seq");
	$query = "INSERT INTO " . cms_db_prefix() . "group_perms (group_perm_id, group_id, permission_id, create_date, modified_date) VALUES (".$new_id.", ".$group_id.", ".$perm_id.", ". $db->DBTimeStamp(time()) . ", " . $db->DBTimeStamp(time()) . ")";
	$db->Execute($query);
}

$group_id = $db->GetOne("SELECT group_id FROM ".cms_db_prefix()."groups WHERE group_name = 'Editor'");

$count = $db->GetOne("SELECT count(*) FROM " . cms_db_prefix() . "group_perms WHERE group_id = ? AND permission_id = ?", array($group_id, $perm_id));
if (isset($count) && intval($count) == 0)
{
	$new_id = $db->GenID(cms_db_prefix()."group_perms_seq");
	$query = "INSERT INTO " . cms_db_prefix() . "group_perms (group_perm_id, group_id, permission_id, create_date, modified_date) VALUES (".$new_id.", ".$group_id.", ".$perm_id.", ". $db->DBTimeStamp(time()) . ", " . $db->DBTimeStamp(time()) . ")";
	$db->Execute($query);
}

$this->SetPreference('template','album_list');
$this->SetPreference('defaulttemplate', 'default');
 // Turn inline links on by default since they cause less problems (i.e. Album will work when called in additional content blocks).
// Doing this does disable pretty URLs, but functionality is more important.
$this->SetPreference('useinlinelinks', 1);
                                                  
$this->InstallDefaultAlbumTemplate('album_list');               
$this->InstallDefaultAlbumTemplate('default');               
$this->InstallDefaultAlbumTemplate('recently_updated');
$this->InstallDefaultAlbumTemplate('random_image');
$this->InstallDefaultAlbumTemplate('categories');
// Categories
$dict = NewDataDictionary($db);

// table schema description
$flds = "
	category_id I KEY,
	category_name C(80),
	category_number I,
	category_comment X
	";

// create it. 
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_album_categories",
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// create a sequence
$db->CreateSequence(cms_db_prefix()."module_album_categories_seq");



// Category Listings
$flds = "
	listing_id I KEY,
	listing_album_id I,
	listing_category_id I,
	listing_number I
	";

// create it. This should do error checking
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_album_category_listings",
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// create a sequence
$db->CreateSequence(cms_db_prefix()."module_album_category_listings_seq");
$txt = file_get_contents($this->GetModulePath().'/css/stylesheet.css');


if ( version_compare('1.99.99', CMS_VERSION, '>=') )
{
  # < 2.0
  $stylesheetops = cmsms()->GetStylesheetOperations();
  
  if( !$stylesheetops->CheckExistingStylesheetName('Album Module') )
  {
    $stylesheet = new Stylesheet();
    $stylesheet->name = 'Album Module';
    $stylesheet->value = $txt;   
    $stylesheet->media_type = 'screen';
    $stylesheetops->InsertStylesheet($stylesheet);
  }
}
else
{
  # > 2.0
  $css = new CmsLayoutStylesheet;
  
  try{ $test = $css->load('Album Module'); } catch(Exception $e) { $test = null; };

  if (!is_object($test))
  {
    $css->set_name('Album Module'); # TODO add this to lang...
    $css->set_description('A sample stylesheet for the Album module'); # TODO add this to lang...
    $css->set_content($txt);
    $css->save();
  }

}

// put mention into the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed', $this->GetVersion()));

?>
