<?php
#-------------------------------------------------------------------------
# Album - Photo Albums
# Version 1.11
# This module allows you to add photo albums to your website
# maintained by Fernando Morgado AKA Jo Morg
# since 2013
#-------------------------------------------------------------------------
#
# Previously maintained by:
# dam & Elijah Lofgren <elijahlofgren@elijahlofgren.com>
#
#-------------------------------------------------------------------------
#
# Album is a CMS Made Simple module that enables the web developer to 
# add photo albums to a website
#
#-------------------------------------------------------------------------
# BEGIN_LICENSE
#-------------------------------------------------------------------------
# This file is part of Album
# Album program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Album program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
# END_LICENSE
#-------------------------------------------------------------------------
class AlbumAdmin extends Album
{
	function getAlbumsFromIds($category_id, $album_ids, $id, $returnid)
	{
		$gCms = cmsms();
		$config = $gCms->config;
		$themeObject = cms_utils::get_theme_object();

		$dbalbums = $this->GetAlbums($album_ids,false,$category_id);
		$albums = array();
		foreach ($dbalbums as $dbalbum)
		{
			$onerow = new stdClass();
	
			$onerow->name = $this->CreateLink($id, 'editalbum', $returnid, $dbalbum->name, array('albumid'=>$dbalbum->id));
			$onerow->template = $this->CreateLink($id, 'editalbum', $returnid, $dbalbum->template, array('albumid'=>$dbalbum->id, 'active_tab' => 'properties'));
			$onerow->id = $dbalbum->id;
			if (FALSE == empty($dbalbum->thumbnail))
			{
				$onerow->thumb = '<img src="'.$dbalbum->thumbnail.'" alt="'.$this->Lang('nothumbnail').'"/>';
			}
			else
			{
				$onerow->thumb = $this->Lang('nothumbnail');
			}
			$onerow->deletelink = $this->CreateLink($id, 'deletealbum', $returnid,
								$this->DisplayImage('trash.png', $this->Lang('deletealbum'),'',
											  '','systemicon'),
								array('albumid' => $dbalbum->id), $this->Lang('areyousure'));
			if (count($albums)>0)
			{
				$onerow->uplink = $this->CreateLink($id, 'movealbum', $returnid,
								    $this->DisplayImage('up.png', lang('up'),'','','systemicon'),
								    array('albumid' => $dbalbum->id, 'direction'=>'up', 'category_id'=>$category_id));
			} else {
				$onerow->uplink = '';
			}
			if (count($albums)<count($dbalbums)-1)
			{
				$onerow->downlink = $this->CreateLink($id, 'movealbum', $returnid,
								      $this->DisplayImage('down.png', lang('down'),'','',
												 'systemicon'),
								      array('albumid' => $dbalbum->id, 'direction'=>'down', 'category_id'=>$category_id));
			} else {
				$onerow->downlink = '';
			}
		
			$onerow->picturenumber = $this->PictureCount($dbalbum->id);
			
			array_push($albums, $onerow);
		}
		return $albums;
	}
}
?>