<?php
$lang['addalbum'] = 'Add an album';
$lang['error_nonamegiven'] = 'You must give a name to your new album.';
$lang['albumadded'] = 'The Album was successfully added. Pictures can be added to it below.';
$lang['albumdeleted'] = 'The album was successfully removed from the database.';
$lang['noalbumstext'] = 'You have not created any photo albums in this category.';
$lang['addpicture'] = 'Add pictures'; 
$lang['addpicturew'] = 'Add pictures<br />If this is the first time this folder has been opened for/by Album, please wait till all thumbs are created to select them, else you will get large images instead';
$lang['addtemplate'] = 'Add a template';
$lang['albumidtext'] = 'IDs';
$lang['albumnametext'] = 'Albums';
$lang['albumthumbtext'] = 'Thumbnails';
$lang['albumnumpicturestext'] = 'Number of pictures';
$lang['albumreordertext'] = 'Reorder';
$lang['albumactionstext'] = 'Actions';
$lang['Albums'] = 'Albums';
$lang['areyousure'] = 'Are you sure ?';
$lang['browsepictures'] = 'Change';
$lang['cancel'] = 'Cancel';
$lang['changecomment'] = 'Edit comment';
$lang['changepicture'] = 'Change picture';
$lang['changethumb'] = 'Change thumbnail';
$lang['changethumbnail'] = 'Change thumbnail';
$lang['columns'] = 'Max number of thumbnail columns (0 means unlimited. Only used on Tables template)';
$lang['comment'] = 'Comment';
$lang['currenttemplate'] = 'Album List Template';
$lang['currentpicture'] = 'Current picture';
$lang['currentthumbnail'] = 'Current thumbnail';
$lang['deletealbum'] = 'Delete';
$lang['deletepicture'] = 'Delete';
$lang['Help'] = 'Help';
$lang['modify'] = 'Change';
$lang['moveleft'] = 'Move up';
$lang['moveright'] = 'Move down';
$lang['multiplealbumtemplate'] = 'Multiple albums template';
$lang['name'] = 'Name';
$lang['nocomment'] = '(no comment)';
$lang['nothumbnail'] = '(no thumbnail)';
$lang['picture'] = 'Picture';
$lang['parentdir'] = '(Parent directory)';
$lang['pictures'] = 'pictures';
$lang['nopicturetext'] = 'There are no pictures in this album.';
$lang['Picture'] = 'Picture';
$lang['Pictures'] = 'Pictures';
$lang['Properties'] = 'Properties';
$lang['propertiesupdated'] = 'The album properties were successfully saved.';
$lang['resetthumb'] = 'Reset thumbnail';
$lang['return'] = 'Submit';
$lang['rows'] = 'Max number of thumbnail rows (0 means unlimited. Only used on Tables template)';
$lang['useinlinelinks'] = '<b>Use Inline Links</b> - This will make the content of the page always be shown with the Album tag above all pictures.<br />In addition <strong>this will make Album work correctly when placed in additional page content blocks</strong>.<br /><strong>NOTE: Enabling this option will disable Album\'s use of pretty URLs.</strong>';
$lang['selectall'] = 'Select all';
$lang['selectpicture'] = 'Use this picture';
$lang['selectthumb'] = 'Use the thumbnail of this picture';
$lang['submit'] = 'Save';
$lang['file_templates_help'] = '<b>These are templates that you must install to the database before you can use them.</b>';
$lang['template'] = 'Template';
$lang['deletetemplate'] = 'Delete Template';
$lang['Template'] = 'Template';
$lang['templatenametext'] = 'Templates';
$lang['Templates'] = 'Templates';
$lang['edittemplate'] = 'Edit Template';
$lang['templatesaved'] = 'The template was successfully saved to the database.';
$lang['errortemplatenameexists'] = 'A template with that name already exists, please choose a different name.';
$lang['error_filenotfound_defaulttemplate'] = 'The template file for this template was not found.';
$lang['thumbnail'] = 'Thumbnail';
$lang['title'] = 'Title';
$lang['uploadpicture'] = 'Upload a picture';
$lang['upload'] = 'Upload';
$lang['view'] = 'View';
$lang['options'] = 'Options';
$lang['optionsupdated'] = 'The options were successfully updated.';
//$lang['defaultrows'] = 'Default max number of thumbnail rows for new albums (0 means unlimited. Only used on Tables template)';
//$lang['defaultcolumns'] = 'Default max number of thumbnail columns for new albums (0 means unlimited. Only used on Tables template)';
$lang['defaulttemplate'] = 'Default Template';
$lang['file_templates'] = 'Available Templates';
$lang['filename'] = 'File Name';
$lang['importtemplate'] = 'Import Template';
$lang['newtemplate'] = 'Name for the new template';
$lang['defaultalbumpage'] = 'Default page that contains Album. This page must contain the Album tag. Required to activate pretty URLs or use the recently_updated feature.';
$lang['album_comment_updated'] = 'The album comment was successfully updated.';
$lang['picture_comment_updated'] = 'The picture comment was successfully updated.';
$lang['template_deleted'] = 'The template was successfully deleted from the database';
$lang['error_empty_template'] = 'Error: The template named "%s" that this Album is set to use does not exist. Please go to the Album Admin Panel and assign a different template to this Album.';
$lang['addcategory'] = 'Add Category';
$lang['categories'] = 'Categories';
$lang['nocategories'] = 'You have not added any categories yet.';
$lang['categorynametext'] = 'Category Name';
$lang['categoryidtext'] = 'Category id';
$lang['categoryreordertext'] = 'Reorder Category';
$lang['categoryactionstext'] = 'Actions';
$lang['categoryadded'] = 'The category was successfully added to the database.';
$lang['categorymoved'] = 'The category was successfully moved.';
$lang['categoryupdated'] = 'The category was successfully updated.';
$lang['editcategory'] = 'Edit Category';
$lang['categorydeleted']  = 'The category was successfully deleted.';
$lang['error_nocategorynamegiven'] = 'You must give a name to your category.';
$lang['category_listings'] = 'Category Listings';
$lang['album_updated'] = 'The album was successfully updated.';
$lang['uncategorized'] = 'Uncategorized Albums';
$lang['albummoved'] = 'The album was successfully moved.';
$lang['msg_import_good'] = 'XML Import Successful';
$lang['info_newname'] = '<em>(optional)</em> specify a new template name.';
$lang['lbl_newname'] = 'New template name';
$lang['error_templateexists'] = 'An album template by the same name already exists';
$lang['error_badpermissions'] = 'The directory permissions are not sufficient to be able to import XML templates';
$lang['error_badxmlformat'] = 'The XML file uploaded is not in the accepted format (or other problem with the file)';
$lang['error_badupload'] = 'An error occurred uploading the file';
$lang['error_baduploadtype'] = 'The uploaded file is not the proper type';
$lang['error_noupload'] = 'No file was uploaded';
$lang['error_param'] = 'A required parameter is missing';
$lang['lbl_select_file'] = 'Select XML File';
$lang['lbl_import'] = 'Import Album Template from XML';
$lang['error_param'] = 'Missing Parameter';
$lang['exporttemplate'] = 'Export to XML';
$lang['template_metadata'] = 'Album Template Metadata';
$lang['Metadata'] = 'Metadata';
$lang['canceled'] = 'Operation canceled';
$lang['submit_edit_next'] = 'Submit &amp; Edit Next';
$lang['friendlyname'] = 'Photo Albums';
$lang['postinstall'] = 'Album is now installed. <p><b>Note: You may have to change File Creation Mask (umask): from "022"
to "002" to keep from getting 403 forbidden errors when trying to view generated thumbnails.</b><br /><br />You have a new style sheet called \'Album Module\' that you will need to attach to the page template.</p>';
$lang['postuninstall'] = 'Album is now removed from the database.';
$lang['uninstalled'] = 'Module uninstalled';
$lang['installed'] = 'Release %s is installed';
$lang['upgraded'] = 'Module upgraded in release %s.';
$lang['error_nofilesuploaded'] = 'There was an error uploading. Please check and make sure the folder is writable.';
$lang['error'] = 'Error!';
$lang['next_picture'] = 'Next Picture';
$land['admin_title'] = 'Photo album manager';
$lang['admindescription'] = 'The Album module allows you to easily display photo galleries on your website.';
$lang['accessdenied'] = 'Access denied';
$lang['query_failed'] = 'A query failed please file a bug.';
$lang['changelog'] = '<ul><li>Version 0.0.1. 5 April 2006. Initial Release.</li></ul>';
$lang['help_albums'] = 'A list of one or more (separated by commas) IDs of Albums to be shown.';
$lang['max_image_size'] = '<b>Maximum image size:</b> Any images larger than this will automatically be scaled down (if the template is configured to do that.) using Javascript.';
$lang['help_sortdesc'] = 'Sort albums in descending order rather than ascending.';
$lang['help_sortpicturesdesc'] = 'Sort pictures in descending order rather than ascending. This will make new pictues that are added to an album to be listed first.<p>Example to show pictures in reverse order:</p><pre>{Album sortpicturesdesc=\'true\'}</pre>';
$lang['templatenameexists'] = 'Error: A template with that name already exists. Please choose a different name.';
$lang['templateimported'] = 'The template was sucessfully imported into the database and is now installed for use.';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>This module can be used to manage picture gallery</p>
<h3>How Do I Use It</h3>
<h4>First go to Content > Photo Albums and create Albums and add pictures to them.</h4><br />
<p>To show all albums on a page, just put this code in your page content:</p>
<p><code>{Album}</code></p>
<p><strong>NOTE:</strong> You have to put this in the Pages metadata box in Options tab:</p>
<p><code>{Album action=\'metadata\'}</code></p>
<p>If you don\'t attach the style sheet to the page add this to the metadata box also:</p>
<p><code>{cms_stylesheet name=\'Album Module\'}</code></p>
<p>If you only want to show albums from a specific category then use use code like this:</p>
<p><code>{Album categories=\'1\'}</code></p>
<p>The code above allows you to show in a page albums who belong to a category whose ID is 1.</p>
<p>You can also show multiple categories like this:</p>
<p><code>{Album categories=\'1,3\'}</code></p>
<p>If you only want certain albums shown then use code like this, you have to have at least 1 "name" in this call, this will show in "albums" mode:</p>
<p><code>{Album albums=\'one,3\'}</code></p>
<p>The code above allows you to show in a page albums whose names and IDs are \'one\' and \'3\' for example. If you do not provide paramater "albums", it will show all the albums.</p>
<p>If you only want 1 specific album shown then use code like this, "name" of album only, this will show in "gallery" mode:</p>
<p><code>{Album albums=\'album name\'}</code></p>
<p>The code above allows you to show in a page an album named "album name" for example.</p>
<p>If you only want to limit the number of thumbs that show in "gallery" mode:</p>
<p><code>{Album number=\'5\'}</code></p>
<p>The code above allows you to show only 5 thumbs of the album at a time with pagination if the gallery has more than the specified number.</p>
<h3>Templates</h3>
<p><b>Templates now have 2 parts to them:</b></p>
<p>(1) The normal Template: edit area where you can configure the loops of for each etc. wrapping them in your choice of DIVs, UL, LI, A links, etc.</p>
<p>(2) The new <b>metadata</b> edit area, this is where you call the:<br />
&lt;script type="text/javascript" src="modules/Album/templates/db/js/jquery.js"&gt;&lt;/script&gt;<br />
&lt;link rel="stylesheet" type="text/css" href="modules/Album/templates/db/default/default.css" media="screen" /&gt;</p>
<pre>
    &lt;script type="text/javascript"&gt;
    $(function() {
        $(\'#jQligallery a\').lightBox();
    });
    &lt;/script&gt;
</pre>
<p>With out having to use {literal} {/literal} around the function call.</p>
<h4>How to change the links and text in the picture popup for the default Album template</h4>
<p>You can change the text in the default Album popup by editing: modules/Album/templates/db/js/thickbox.js (this is not ideal for upgradability, but it seems to work fine)</p>

<h3>Troubleshooting</h3>
<p>Talk to your developer about using ImageMagick instead of GD, it performs better.</p>
<h4>Fix large gap problems caused by clear:both:</h4>
<p>Short answer, add this to your Stylesheet:</p>
<pre>
#main {
float: left;
}
</pre>
<h4>Thumbnails not working</h4>
<p><b>Note: You may have to change File Creation Mask (umask): from "022" to "002" to keep from getting 403 forbidden errors when trying to view generated thumbnails on your webhost.</b></p>
<h4>Thumbnails don\'t line up correctly:</h4>
<p>You may need to add a height: parameter to the Album Module style sheet, find the tallest one and set \'.picturelist .thumb\' to that height then they should all float correctly.</p>

<h4>Increasing the size of the thumbnails:</h4>
<p>Look in Site Admin > Global Settings for Thumbnail Width, Thumbnail Height this will find the biggest number between the 2 and set it to your size, if you generate any thumbnails before setting this you need to delete those thumbnails and make them again.</p>

 <h3>Parameters:</h3>
<ul>
  <li><em>(optional)</em> albums="1,name of album" - A list of one or more (separated by commas) IDs/names of Albums to be shown, requires at least one "name".</li>
  <li><em>(optional)</em> number="5" - Limit the number of thumbnails shown in \'Gallery\' mode.</li>
  <li><em>(optional)</em> sortdesc="true" - Sort albums in descending order rather than ascending.</li>
  <li><em>(optional)</em> sortpicturesdesc="false" - Sort pictures in descending order rather than ascending. This will make new pictues that are added to an album to be listed first.
  <p>Example to show pictures in reverse order: <code>{Album sortpicturesdesc=\'true\'}</code></p>
  </li> 

  <li>
  <em>(optional)</em> detailpage="pagealias" - 
  <p>Page to display Albums in.  This can either be a page alias or an id. Used to allow Album pictures  to be displayed in a different page from the album list.<br /> 
  Example of use: <code>{Album detailpage=\'album\'}</code></p>
  </li>
  <li><em>(optional)</em> action="default" -  
  <h4>Show list of recently added pictures:</h4>	 
  <p>You can show a list of added pictures calling Album like this: <code>{Album action=\'recently_updated\'}</code></p>
  </li>
  <li><em>(optional) </em> number="10" -  
  <h4>Show a certain number of recently updated pictures:</h4>
  <p>You can show a list of a certain number of pictures by calling Album like this: <code>{Album action=\'recently_updated\' number=\'15\'}</code></p>
  <p>If you want to show recent pictures from a specific Album (e.g. album id 1) you can call Album like this: <code>{Album albums=\'1\' action=\'recently_updated\' number=\'2\'}</code></p>
  <p><b>Important</b>: You must choose a "<b>Default page that contains Album.</b>" in order to use this feature.</p>
  </li>
  <li>
  <h4>Show random image:</h4>
  <p>First it counts all rows in the database (accounting the included Albums), finds a random number between \'0\' and the maximum number of rows. With this number the database pointer is being set to a specific row and the data is retrieved from the table and returned.</p>
  <p>How do I use it?<br />Just insert the tag into your template/page like: <code>{Album action=\'random_image\'}</code></p>
  <p>To show a certain number of random images call it like this: <code>{Album action=\'random_image\' number=\'10\'}</code></p>
  <p>What parameters the random_image action take?</p>
  <ul>	
    <li><em>(optional)</em> <tt>imagesurl</tt> - Album directory, default is: \'root_url\'/uploads/images</li>	
    <li><em>(optional)</em> <tt>albums</tt> - comma, space, dash or semicolon separated list of albums to show images of.</li>  
    <li><em>(optional)</em> <tt>border</tt> - stylesheetstyled border ala border=\'5px\'</li>  
    <li><em>(optional)</em> <tt>picturename</tt> - picturename = True/False, sets a title with the picture name</li>
  </ul>
  <p><b>Note: These parameters are only available when calling Album with {Album action=\'random_image\'}</b></p>
  <p>so for example: <code>{Album action=\'random_image\' albums=\'1,3,4,6\' border=\'3px\' picturename=\'True\'}</code></p>
  <p>Random Image Author: Frank Prins</p>
  </li>
</ul>
  <h3>Support</h3>
  <p>As per the GPL, this software is provided as-is. Please read the text of the license for the full disclaimer.</p>
  <h3>Copyright and License</h3>
  <p>Copyright &copy; 2006, dam. All Rights Are Reserved.</p>
  <p>This module has been released under the 
    <a target="_blank" href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.
  </p>';

$lang['help_template'] = '
<h3>Important tips for modifying templates</h3>
<h4>Enable debug mode!</h4>
<p>Unless you enable debug mode, important errors about undefined template variables will be hidden, making debugging templates very difficult!</p>
<p>You can enable debug mode by opening config.php and setting:</p>
<code>$config[\'debug\'] = true;<code>

<h3>Album list</h3>

<p>You can use smarty tag {$albums} which is an array. Each of its elements is one of the selected albums.
The structure of an album is described in next chapter.
To show the albums, use loop <code>{foreach from=$albums item=album}{/foreach}</code></p>
<h3>Album</h3>
<p>If there is only one album, or if a specific album is selected, you can use tag {$album}. It allows to access following items :</p>
<ul>
	<li>{$album->name} : name</li>
	<li>{$album->comment} : comment</li>
	<li>{$album->columns} : column number</li>
	<li>{$album->rows} : row number</li>
	<li>{$album->thumbnail} : adress (url) of thumbnail</li>
	<li>{$album->link} : link to album</li>
	<li>{$album->picturecount} : number of pictures of an album</li>
</ul>
<h3>Image list</h3>
<p>If an album is selected, you can use tag {$pictures} which is an array of arrays : it contains rows that contain pictures.
The structure of an image is described in following chapter.
To show image list, use the following loop :
<code>{foreach from=$pictures item=picturesrow}
	{foreach from=$picturesrow item=onepicture}
	{/foreach}
{/foreach}</code></p>
<h3>Picture</h3>
<p>If a picture is selected, you can use tag  {$picture}. It is automatically set to first picture of album if no picture is selected.</p>
<ul>
	<li>{$picture->name} : name</li>
	<li>{$picture->comment} : comment</li>
	<li>{$picture->comment2} : comment2</li>
	<li>{$picture->comment3} : comment3</li>
	<li>{$picture->thumbnail} : adress (url) of thumbnail</li>
	<li>{$picture->picture} : adress (url) of picture</li>
	<li>{$picture->link} : link to picture</li>
	<li>{$picture->number} : picture number</li>
	<li>{$picture->thumbnailwidth}: width of thumbnail</li>
	<li>{$picture->thumbnailheight}: height of thumbnail</li>
	<li>{$picture->autothumbnailsize}: outputs something like \'height="76"\' to make tall thumbnails fit in a box</li>
	<li>{$max_image_size}: The value of the max_image_size preference. Used in the default template to automatically resize images that are too large.</li>
</ul>
<h3>Other</h3>
<p>You can also use following tags :</p>
<ul>
	<li>{$returnlink} : back to previous page</li>
	<li>{$albumnumber} : current album number</li>
	<li>{$albumcount} : album count</li>
	<li>{$picturenumber} : current picture number</li>
	<li>{$picturecount} : picture count</li>
	<li>{$pagenumber} : current page number</li>
	<li>{$pagecount} : page count</li>
	<li>{$link.album.1} : link to first album. You can also indicate another number</li>
	<li>{$link.album.first}, {$link.album.previous}, {$link.album.next}, {$link.album.last}</li>
	<li>{$link.picture.1} : link to first picture. You can also indicate another number</li>
	<li>{$link.picture.first}, {$link.picture.previous}, {$link.picture.next}, {$link.picture.last}</li>
	<li>{$link.page.1} : link to first page. You can also indicate another number</li>
	<li>{$link.page.first}, {$link.page.previous}, {$link.page.next}, {$link.page.last}</li>
</ul>  
';
?>