<?php
#-------------------------------------------------------------------------
# Album - Photo Albums
# Version 1.11
# This module allows you to add photo albums to your website
# maintained by Fernando Morgado AKA Jo Morg
# since 2013
#-------------------------------------------------------------------------
#
# Previously maintained by:
# dam & Elijah Lofgren <elijahlofgren@elijahlofgren.com>
#
#-------------------------------------------------------------------------
#
# Album is a CMS Made Simple module that enables the web developer to 
# add photo albums to a website
#
#-------------------------------------------------------------------------
# BEGIN_LICENSE
#-------------------------------------------------------------------------
# This file is part of Album
# Album program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Album program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
# END_LICENSE
#-------------------------------------------------------------------------
if( !defined('CMS_VERSION') ) exit;

$category_id = (isset($params['category_id']) ? $params['category_id'] : '');
if ($category_id == '')
	$this->Redirect($id, 'defaultadmin', $returnid);

if(! $this->CheckPermission( 'Use Album' ) ) exit;

// Get the category number
$db_category = $this->GetCategory($category_id);
$category_number = $db_category->number;

// Delete the category
$query = "DELETE FROM ".cms_db_prefix()."module_album_categories WHERE category_id = ?";
$db->Execute($query, array($category_id));

// Delete category listings
$query = "DELETE FROM ".cms_db_prefix()."module_album_category_listings WHERE listing_category_id = ?";
$db->Execute($query, array($category_id));

// Update Category numbers
$query = 'UPDATE '.cms_db_prefix().'module_album_categories SET category_number=category_number-1 WHERE category_number > ?';
$db->Execute($query, array($category_number));

$params = array('tab_message' => 'categorydeleted', 'active_tab' => 'categories');
$this->Redirect($id, 'defaultadmin', $returnid, $params);
?>
