<?php
#-------------------------------------------------------------------------
# Album - Photo Albums
# Version 1.11
# This module allows you to add photo albums to your website
# maintained by Fernando Morgado AKA Jo Morg
# since 2013
#-------------------------------------------------------------------------
#
# Previously maintained by:
# dam & Elijah Lofgren <elijahlofgren@elijahlofgren.com>
#
#-------------------------------------------------------------------------
#
# Album is a CMS Made Simple module that enables the web developer to 
# add photo albums to a website
#
#-------------------------------------------------------------------------
# BEGIN_LICENSE
#-------------------------------------------------------------------------
# This file is part of Album
# Album program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Album program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
# END_LICENSE
#-------------------------------------------------------------------------
if( !defined('CMS_VERSION') ) exit;

// Used for AlbumBlockContent. @TODO Do in a more elegant way
$AlbumCalled = 1;

// Get our CMS DB and config options.
$gCms = cmsms();
$db =  cmsms()->GetDb();
$config = cmsms()->GetConfig();
$query_var = $config['query_var'];

// == parameters == // 
// The detailpage parameter is used to allow Album pictures to be displayed in a different page from the album list
$detailpage = '';
if (isset($params['detailpage']))
{
	$manager = $gCms->GetHierarchyManager();
	$node = $manager->sureGetNodeByAlias($params['detailpage']);
	if (isset($node))
	{
		$content = $node->GetContent();	
		if (isset($content))
		{
			$returnid = $content->Id();
		}
	}
	else
	{
		$node = $manager->sureGetNodeById($params['detailpage']);
		if (isset($node))
		{
			$returnid = $params['detailpage'];
		}
	}
}
$sortdesc = (isset($params['sortdesc']) ? $params['sortdesc'] : false);

$albums = array();
$albumids = array();
$albumid = '';
if( isset($params['albumid']) )
  {
    $albumid = (int)$params['albumid'];
  }
else if( isset($params['albums']) )
  {
    $tmp = explode(',',$params['albums']);
    $tmpi = array();
    $tmps = array();
    for( $i = 0; $i < count($tmp); $i++ )
      {
	if( is_numeric($tmp[$i]) )
	  {
	    $tmpi[] = (int)$tmp[$i];
	  }
	else
	  {
	    $tmps[] = "'".trim($tmp[$i])."'";
	  }
      }
    $query = 'SELECT distinct album_id FROM '.cms_db_prefix().'module_album_albums WHERE album_name';
    $f = 0;
    if( count($tmps) )
      {
	$query .= ' IN ('.implode(',',$tmps).')';
	$f++;
      }
    if( count($tmpi) )
      {
	if( $f )
	  {
	    $query .= ' OR';
	  }
	$query .= ' album_id IN ('.implode(',',$tmpi).')';
      }
    $albumids = $db->GetCol($query);
    if( !is_array($albumids) || count($albumids) == 0 )
      {
	// could not find any albums.
	return;
      }
    if( count($albumids) == 1 )
      {
	$albumid = $albumids[0];
	$albumids = array();
      }
  }
  
  $categories = (isset($params['categories']) ? $params['categories'] : false);
// == end parameters == //


// Get page hiearchy path of the page from which Album is being called.
// This is used to make URLs prettier
$q = "SELECT hierarchy_path FROM ".cms_db_prefix()."content WHERE content_id='".$returnid."'";
$dbresult = $db->Execute( $q );
if (!$dbresult)
{
	echo 'DB error: '. $db->ErrorMsg()."<br/>";
}
else
{
	$call_page = $dbresult->FetchRow();
	$hierarchy_path = $call_page['hierarchy_path']; // TODO Move this to be a pref that is overwriddable by a param.
}

// If the categories parameter has been passed. i.e. {cms_module module='album' categories='1'}
// but only if we are not viewing an album
if ($categories && TRUE == empty($albumid))
{
	// Get an array of album ids that belong to this category
	$category_album_ids = $this->GetAlbumsInCategory($categories, $sortdesc);
	// If there are no albums in this category
	if (empty($category_album_ids))
	{
		// Display an error
		echo $this->Lang('noalbumstext');
	}
	else
	{
		// Get the information about all the categories that have been requested. i.e.: {cms_module module='album' categories='1,3'}
		$db_categories = $this->GetCategories($categories, $sortdesc);
		$categories = array();
		// Loop through each of the categories
		foreach ($db_categories as $db_category)
		{
			// Get an array containing the data of all the albums in this category
			$this->albums = $this->GetAlbums($category_album_ids[$db_category->id], $sortdesc, $db_category->id);
	
			// Get the content of these albums
			$albums_content = '';

			// If the 'auto' option for 'Album List Template' is selected, then go through each
			// album one by one, and list it using the template that is assigned to it
			if ('auto' == $this->GetPreference('template','default'))
			{
				for ($i = 0 ; $i < count($this->albums) ; $i++)
				{
					$albums_content .= $this->ShowFrontendAlbumList($i, $hierarchy_path, $albumid, $id, $returnid, $params);
				}
			}
			else
			{
				$albums_content = $this->ShowFrontendAlbumList(0, $hierarchy_path, $albumid, $id, $returnid, $params);
			}

			// Add the output of these albums to a categories array
			$categories[] = array ('albums_content' =>  $albums_content, 'category' => $db_category);
		}
			// Make the array of album content available as an array to smarty
			$smarty->assign('categories', $categories);
			// Get the 'categories' template
			$db_templatecontent = $this->GetTemplate('categories');
			// Use the database 'categories' template if it exists
			if (FALSE == empty($db_templatecontent))
			{
				$output = $this->ProcessTemplateFromDatabase('categories');
			}
			else // Otherwise just use the file categories template
			{
				$output = $this->ProcessTemplate('db/categories.tpl');
			}
			echo $output;
	}
}
else // Categories are not in use
{
	// This is very important to make both the album list and thumbnail list work correctly
	if (empty($albumid))
	{
		$this->albums = $this->GetAlbums($albumids, $sortdesc);
	}
	else
	{
		// Get only pictures in a specific album?
		$this->albums = $this->GetAlbums($albumid, $sortdesc);
	}

	echo $this->ShowFrontendAlbumList(0, $hierarchy_path, $albumid, $id, $returnid, $params);
}

?>