<?php
#-------------------------------------------------------------------------
# Album - Photo Albums
# Version 1.11
# This module allows you to add photo albums to your website
# maintained by Fernando Morgado AKA Jo Morg
# since 2013
#-------------------------------------------------------------------------
#
# Previously maintained by:
# dam & Elijah Lofgren <elijahlofgren@elijahlofgren.com>
#
#-------------------------------------------------------------------------
#
# Album is a CMS Made Simple module that enables the web developer to 
# add photo albums to a website
#
#-------------------------------------------------------------------------
# BEGIN_LICENSE
#-------------------------------------------------------------------------
# This file is part of Album
# Album program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Album program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
# END_LICENSE
#-------------------------------------------------------------------------
if( !defined('CMS_VERSION') ) exit;
if(! $this->CheckPermission( 'Use Album' ) ) exit;

$pictureid = (isset($params['pictureid']) ? $params['pictureid'] : '');
$albumid = (isset($params['albumid']) ? $params['albumid'] : '');



if ((isset($params['submit']) || isset($params['cancel'])) && $albumid=='')
{
	$albumid = $this->GetAlbumId($pictureid);
}

if (isset($params['cancel']))
	$this->Redirect($id, 'editalbum', $returnid,array('albumid'=>$albumid));


if (isset($params['submit']))
{
	// Clear the site cache
	if ($pictureid!='')
	{
		$query = 'UPDATE '.cms_db_prefix().'module_album_pictures SET comment=?, comment2=?, comment3=?, picture_name=? WHERE picture_id = ?';
		$db->Execute($query, array($params['comment'], $params['comment2'], $params['comment3'], $params['title'],$pictureid));
		//Update search index
		$module = $this->GetModuleInstance('Search');
		if ($module != FALSE)
		  {
		    $module->AddWords($this->GetName(), $pictureid, 'album_picture', $params['title']. ' '.$params['comment']);
		  }

		if($params['submit'] == $this->Lang('submit_edit_next')) {
			//Find next picture & determine if this is the last one
			$dbpictures = $this->GetPictures($albumid);
			$break = false;
			$count = 0;
			
			foreach ($dbpictures as $dbpicture) {
				$count++;
				if($break) {

					$params = array('albumid' => $albumid, 'tab_message' => 'picture_comment_updated', 'active_tab' => 'pictures');

					$params['pictureid'] = $dbpicture->id;
					if($count == count($dbpictures)) {
						$params['isLast'] = true;
					}
					$this->Redirect($id, 'changecomment', $returnid, $params);
					return;
				}
				if($dbpicture->id == $pictureid) {
					$break = true;
				}
			}
			
		}
		


		$params = array('albumid' => $albumid, 'tab_message' => 'picture_comment_updated', 'active_tab' => 'pictures');
		$this->Redirect($id, 'editalbum', $returnid, $params);
	}
	elseif ($albumid!='')
	{
		$query = 'UPDATE '.cms_db_prefix().'module_album_albums SET comment=? WHERE album_id = ?';
		$db->Execute($query, array($params['comment'],$albumid));
		//Update search index
		$module = $this->GetModuleInstance('Search');
		if ($module != FALSE)
		  {
		    $module->AddWords($this->GetName(), $albumid, 'album', $params['comment']);
		  }
		$params = array('albumid' => $albumid, 'tab_message' => 'album_comment_updated', 'active_tab' => 'pictures');
		
		$this->Redirect($id, 'editalbum', $returnid, $params);
	}
}

if ($pictureid != '')
{
	$dbpicture = $this->GetPicture($pictureid);
	$title = $dbpicture->name;	
	$albumcomment = $dbpicture->comment;
	$albumcomment2 = $dbpicture->comment2;
	$albumcomment3 = $dbpicture->comment3;
	$thumbnailpath = $dbpicture->thumbnail;
	$albumid = $dbpicture->albumid;
	$smarty->assign('showtitle', 1);
	$comment2 = '<div class="pageoverflow">
		<p class="pagetext">'.$this->Lang('comment').' 2:</p>
		<p class="pageinput">'.$this->CreateTextArea(true, $id, $albumcomment2, 'comment2', '', '', '', '', '80', '5').'</p>
	</div>';
	$smarty->assign('comment2', $comment2);
	$comment3 = '<div class="pageoverflow">
		<p class="pagetext">'.$this->Lang('comment').' 3:</p>
		<p class="pageinput">'.$this->CreateTextArea(true, $id, $albumcomment3, 'comment3', '', '', '', '', '80', '5').'</p>
	</div>';
	$smarty->assign('comment3', $comment3);


}
elseif ($albumid != '')
{
	$title = '';
	$dbalbum = $this->GetAlbum($albumid);
        $albumname = $dbalbum->name;
        $albumcomment = $dbalbum->comment;
        $thumbnailpath = $dbalbum->thumbnail;
	$smarty->assign('showtitle', 0);
	$smarty->assign('comment2', '');
	$smarty->assign('comment3', '');
}
$smarty->assign('thumbnail', '<img alt="" src="'.$thumbnailpath. '" />');
$smarty->assign('texttitle', $this->Lang('title'));
$smarty->assign('inputtitle', $this->CreateInputText($id, 'title', $title, 50, 255));
$smarty->assign('textcomment', $this->Lang('comment'));
$smarty->assign('inputcomment', $this->CreateTextArea(true, $id, $albumcomment, 'comment', '', '', '', '', '80', '5'));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit',$this->Lang('submit')));
// doesn't really work
//if (!isset($params['isLast'])) {
//	$smarty->assign('submitNext', $this->CreateInputSubmit($id, 'submit',$this->Lang('submit_edit_next')));
//}
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel',$this->Lang('cancel')));


echo $this->CreateFormStart($id, $params['action'], $returnid);
echo $this->ProcessTemplate('changecomment.tpl');
echo $this->CreateInputHidden($id, 'albumid',$albumid);
echo $this->CreateInputHidden($id, 'pictureid',$pictureid);
echo $this->CreateFormEnd();

?>
