<?php
#-------------------------------------------------------------------------
# Album - Photo Albums
# Version 1.11
# This module allows you to add photo albums to your website
# maintained by Fernando Morgado AKA Jo Morg
# since 2013
#-------------------------------------------------------------------------
#
# Previously maintained by:
# dam & Elijah Lofgren <elijahlofgren@elijahlofgren.com>
#
#-------------------------------------------------------------------------
#
# Album is a CMS Made Simple module that enables the web developer to 
# add photo albums to a website
#
#-------------------------------------------------------------------------
# BEGIN_LICENSE
#-------------------------------------------------------------------------
# This file is part of Album
# Album program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Album program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
# END_LICENSE
#-------------------------------------------------------------------------
if( !defined('CMS_VERSION') ) exit;

if(! $this->CheckPermission( 'Use Album' ) ) exit;

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'categories');
	$this->Redirect($id, 'defaultadmin', '', $params);
}

$categoryname = (isset($params['categoryname']) ? $params['categoryname'] : '');
$category_comment = (isset($params['category_comment']) ? $params['category_comment'] : '');


if (isset($params['submit']))
{
	if ($categoryname != "")
	{
		$categoryid = $db->GenID(cms_db_prefix()."module_album_categories_seq");
		$categorynumber = $this->categoryCount()+1;
		
		$query = 'INSERT INTO '.cms_db_prefix().'module_album_categories (category_id,category_name,category_comment,category_number) VALUES (?,?,?,?)';
		$db->Execute($query, array($categoryid,$categoryname,$category_comment,$categorynumber));

		$params = array('tab_message' => 'categoryadded', 'active_tab' => 'categories');
		$this->Redirect($id, 'defaultadmin', '', $params);
	}
	else
	{
		echo $this->ShowErrors($this->Lang('error_nocategorynamegiven'));	
	}
}


$smarty->assign('nametext', $this->Lang('name'));
$smarty->assign('nameinput', $this->CreateInputText($id, 'categoryname', $categoryname, 30, 255));
$smarty->assign('commenttext', $this->Lang('comment'));
$smarty->assign('commentinput', $this->CreateTextArea(true, $id, $category_comment, 'category_comment', '', '', '', '', '80', '5'));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));

echo $this->CreateFormStart($id, 'addcategory', $returnid);
echo $this->ProcessTemplate('editcategory.tpl');
echo $this->CreateFormEnd();

?>
