<?php
#-------------------------------------------------------------------------
# Album - Photo Albums
# Version 1.11
# This module allows you to add photo albums to your website
# maintained by Fernando Morgado AKA Jo Morg
# since 2013
#-------------------------------------------------------------------------
#
# Previously maintained by:
# dam & Elijah Lofgren <elijahlofgren@elijahlofgren.com>
#
#-------------------------------------------------------------------------
#
# Album is a CMS Made Simple module that enables the web developer to 
# add photo albums to a website
#
#-------------------------------------------------------------------------
# BEGIN_LICENSE
#-------------------------------------------------------------------------
# This file is part of Album
# Album program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Album program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
# END_LICENSE
#-------------------------------------------------------------------------
if( !defined('CMS_VERSION') ) exit;
if(! $this->CheckPermission( 'Use Album' ) ) exit;


//debug_display($params); die();
$albumname = (isset($params['albumname']) ? $params['albumname'] : '');

if (isset($params['cancel']))
  {
    $params = array('module_message' => $this->lang('canceled'));
    $this->Redirect($id, 'defaultadmin', $returnid, $params);
  }
else if (isset($params['submit']))
{
	if ($albumname != "")
	{
	  $query = 'SELECT album_id FROM '.cms_db_prefix().'module_album_albums WHERE album_name = ?';
	  $tmp = $db->GetOne($query,array($albumname));
	  if( $tmp )
	    {
		$params = array('albumid' => $albumid, 'module_error' => $this->lang('error_name_exists'));
		$this->Redirect($id, 'editalbum', $returnid, $params);
	    }

		$albumid = $db->GenID(cms_db_prefix()."module_album_albums_seq");
		$albumnumber = $this->AlbumCount()+1;
		
		$query = 'INSERT INTO '.cms_db_prefix().'module_album_albums (album_id,album_name,album_number,template) VALUES (?,?,?,?)';
		 $db->Execute($query, array($albumid,$albumname,$albumnumber,$this->GetPreference('defaulttemplate', '')));

		 //Update search index
		 $module = $this->GetModuleInstance('Search');
		 if ($module != FALSE)
		   {
		     $module->AddWords($this->GetName(), $albumid, 'album', $albumname);
		   }

		$params = array('albumid' => $albumid, 'module_message' => $this->lang('albumadded'));
		$this->Redirect($id, 'editalbum', $returnid, $params);
	}
	else
	{
		echo $this->ShowErrors($this->Lang('error_nonamegiven'));	
	}
}


$smarty->assign('nametext', $this->Lang('name'));
$smarty->assign('nameinput', $this->CreateInputText($id, 'albumname', $albumname, 30, 255));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));

echo $this->CreateFormStart($id, 'addalbum', $returnid);
echo $this->ProcessTemplate('newalbum.tpl');
echo $this->CreateFormEnd();

?>
