<?php
#-------------------------------------------------------------------------
# Module: FormBrowser
# Author: Samuel Goldstein, Morten Poulsen
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2014 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/formbuilder
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!defined('CMS_VERSION')) exit;
if (!$this->CheckAccess()) exit;

$db = $gCms->GetDb();
$dict = NewDataDictionary($db);
$sqlarray = $dict->DropTableSQL(cms_db_prefix().'module_fbr_browser');
$dict->ExecuteSQLArray($sqlarray);

$db->DropSequence(cms_db_prefix().'module_fbr_browser_seq');

$sqlarray = $dict->DropTableSQL(cms_db_prefix().'module_fbr_browser_attr');
$dict->ExecuteSQLArray($sqlarray);

$db->DropSequence(cms_db_prefix().'module_fbr_browser_attr_seq');

// remove the permissions
$this->RemovePermission('Modify Browsers');
$this->RemovePermission('Add Browsers');
$this->RemovePermission('View Browsers');
$this->RemovePermission('Export Browsers');
$this->RemovePermission('Delete Browsers');
$this->RemovePermission('Config Form Browser');
$this->RemovePermission('Modify Records');
$this->RemovePermission('Browse Records List');
$this->RemovePermission('Browse Records Full');
$this->RemovePermission('Delete Records');

$this->RemoveEvent( 'OnFormBrowserRecordEdit' );
$this->RemoveEvent( 'OnFormBrowserRecordDelete' );
$this->RemoveEvent( 'OnFormBrowserRecordAdd' );
$this->RemoveEvent( 'OnFormBrowserRecordView' );


$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('uninstalled'));

#
# EOF
#
?>