<?php
#-------------------------------------------------------------------------
# Module: FormBrowser
# Author: Samuel Goldstein, Morten Poulsen
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2014 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/formbuilder
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!defined('CMS_VERSION')) exit;
if (!$this->CheckAccess()) exit;
$db = $gCms->GetDb();

$taboptarray = array('mysql' => 'TYPE=MyISAM');
$dict = NewDataDictionary($db);

$flds = "
	browser_id I KEY,
	form_id I,
	name C(255),
	alias C(255)
	";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_fbr_browser",
	$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_fbr_browser_seq");


$flds = "
	browser_attr_id I KEY,
	browser_id I,
	name C(35),
	value X
";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_fbr_browser_attr',
	$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_fbr_browser_attr_seq");

$this->CreatePermission('Modify Browsers','Modify Form Browsers');
$this->CreatePermission('Add Browsers','Add Form Browsers');
$this->CreatePermission('View Browsers','View Form Browsers');
$this->CreatePermission('Export Browsers','Export Form Browsers');
$this->CreatePermission('Delete Browsers','Delete Form Browsers');
$this->CreatePermission('Config Form Browser','Config Form Browsers');
$this->CreatePermission('Modify Records','Modify Form Browser Records');
$this->CreatePermission('Browse Records List','Browse Form Browser Records (List View)');
$this->CreatePermission('Browse Records Full','Browse Form Browser Records (Full View)');
$this->CreatePermission('Delete Records','Delete Form Browser Records');

$this->CreateEvent( 'OnFormBrowserRecordEdit' );
$this->CreateEvent( 'OnFormBrowserRecordDelete' );
$this->CreateEvent( 'OnFormBrowserRecordAdd' );
$this->CreateEvent( 'OnFormBrowserRecordView' );
$this->CreateEvent( 'OnFormBrowserRecordEditPostSave' );
$this->CreateEvent( 'OnFormBrowserRecordAddPostSave' );



$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));

#
# EOF
#
?>