<?php
#-------------------------------------------------------------------------
# Module: FormBrowser
# Author: Samuel Goldstein, Morten Poulsen
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2014 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/formbuilder
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

/**
 * Core functions contains all the functions needed by FormBrowser
 * Refactorised by Jean-Christophe Cuvelier on Feb 26, 2009
 */

if (!function_exists('GetFormIdFromName'))
{
	function GetFormIdFromName($name='')
	{
		$result = false;
		if ($name != '')
		{
			$gCms = cmsms();
			$db =& $gCms->GetDb();
			$sql = "SELECT form_id FROM ".cms_db_prefix()."module_fbr_browser WHERE name = ? or alias=?";
			$rs = $db->Execute($sql, array($name,$name));
			if ($rs && $rs->RecordCount() > 0)
			{
				$result = $rs->Fields('form_id');
			}
		}
		return $result;
	}
}

if (!function_exists('GetFieldId'))
{
	function GetFieldId($form_id='', $name='')
	{
		$result = false;
		if (($form_id != '') && ($name != ''))
		{
			$gCms = cmsms();
			$db = $gCms->GetDb();
			$sql = "SELECT field_id FROM ".cms_db_prefix()."module_fb_field WHERE (form_id = ?) AND (name = ?)";
			$rs = $db->Execute($sql, array($form_id, $name));
			if ($rs && $rs->RecordCount() > 0) $result = $rs->Fields('field_id');
		}
		return $result;
	}
}

if (!function_exists('GetRespId'))
{
	function GetRespId($arr_field_val)
	{
		$result = false;
		if (!empty($arr_field_val))
		{
			$arr = array();
			$q = '';
			foreach($arr_field_val as $field=>$val)
			{
				$q .= " ( value LIKE CONCAT('%', ? ,'%') AND (field_id = ?) ) OR";
				$arr[] = $val['value'];
				$arr[] = $val['id'];
			}
			$q = substr($q, 0, -2);
			$gCms = cmsms();
			$db = $gCms->GetDb();
			$sql = "SELECT DISTINCT resp_id FROM ".cms_db_prefix()."module_fb_resp_val WHERE $q";
			$rs = $db->Execute($sql, $arr);
			while (($rs && $rs->RecordCount() > 0) && ($row = $rs->FetchRow()))
			{
				$result[] = $row['resp_id'];
			}
		}
		return $result;
	}
}

#
# EOF
#
?>