<h3>What Does This Do?</h3>
<p>Form browser allows you to build simple database applications based upon the forms from Form Builder.</p>

<h3>How Do I Use It?</h3>
<P>Install it, and poke around the menus. Play with it. Try creating browsers, and adding them to your content.
If you get stuck, chat with me on the #cms IRC channel, post to the forum, send me email, or, if you're
really desperate, read the rest of this page.</P>

<h3>How Do I Create a Browser?</h3>
<p>In the CMS Admin Menu, you should get a new menu item called FormBrowser under Content. Click on this. On the page
that gets shown, there are options (at the bottom of the list of Browsers, if any) to Add a New Browser or Modify
Configuration.</p>
<p>Once you've created a browser, you need to select a FormBuilder form for which it displays results. If this FormBuilder form doesn't use the Database Disposition, you're not going to see any results, so make sure you pick a form that makes sense!</p>
<p>Once you've selected a form, you can re-order the field display in four places: the list view and the detail or full view, both on the user side and the admin side. You can also set a bunch of options, such as the number of rows displayed in list views, whether or not editing/adding/deleting is permitted on the user side, and so on. You can edit the templates for the display of the list view and full detail view on the user side.</p>
<p>When re-ordering fields, make sure that you think of the numbers as "slots" rather than "weights" -- in other words, don't use the same order number for two different fields, or it won't work the way you think it should.</p>

<h3>Administering a Browser</h3>
<p>By clicking on the key next to a browser in the admin list, you can go in and add/edit/delete/approve/disapprove records. If the form was created with User Approval, you won't see it in the admin unless the user has validated.</p>

<h3>Adding a Browser to a Page</h3>
<p>In the main FormBrowser admin page, you can see an example of the tag used to display each form. It looks
something like {cms_module module='FormBrowser' browser='sample_browser'}</p>
<p>By copying this tag into the content of a page, or into a template, will cause that browser to be displayed.
In theory, you can have multiple browsers on a page if you really want to, although this would be a sure sign of mental impairment and total disregard for database abuse. Be careful when pasting the tag
into a page's content if you use a WYSIWYG editor such as TinyMCE or HTMLArea. These editors may stealthily
change the quote marks (") into HTML entities (&amp;quot;), and the browser will not show up. Try using
single quotes (') or editing the HTML directly.</p>

<h3>Sorting</h3>
<p>This is now implemented internally by the Index Fields setting in FormBuilder. When you
add a FormBrowser disposition to a form, you select which fields are sortable. They magically
become sortable here in FormBrowser.</p>
<p>If you do NOT want columns to be sortable, edit your template. Look for the section that is like:<br />
<pre>{section name=namelist start=0 loop=$count}
    <th>{$sortingnames[$smarty.section.namelist.index]}</th>
{/section}
</pre>
<p>Use $sortingnames if you want the columns to be sortable, use $names if you don't.</p>

<h3>Filtering Search Results</h3>
<p>if you add filter_field="name" and filter_value="value" to your FormBrowser tag, only records where the "name" field has the value "value" will be listed. Valid field names for filtering are "index1" through
"index5" which correspond the the sortable fields.</p>

<h3>What's New</h3>
<p>This is a small list with the most important changes. For details please consult the changelog.</p>
<ul>
  <li>The module is now compatibible with CMSMS 2.x and PHP 7.x;</li>
  <li>Export to Excel now is more configurable;</li>
  <li>There are important changes to how permissions are handled from this version on:
    <ul>
      <li><strong>"Modify Browsers"</strong> acts as a catch-all permission due to legacy reasons but it is <strong>deprecated</strong> and we strongly discourage its use in favor of the new granular permissions.<br />
      <strong>Please remove this permission from the users and use the new permissions</strong>.<br />
      However, if used, it should let users into any Form Browser area;</li>
      <li><strong>New Permissions</strong>:
        <ul>
          <li><strong>"Add Browsers"</strong> allows users to create new Form Browsers;</li>
          <li><strong>"View Browsers"</strong> allows users to view Form Browsers;</li>
          <li><strong>"Export Browsers"</strong> allows users to use the "Export to Excel" feature;</li>          
          <li><strong>"Delete Browsers"</strong> allows users to delete Form Browsers;</li>
          <li><strong>"Config Form Browser"</strong> allows users to edit the Form Browser configuration settings;</li>
          <li><strong>"Modify Records"</strong> allows users to edit records in Form Browsers;</li>
          <li><strong>"Delete Records"</strong> allows users to delete records in Form Browsers;</li>
        </ul>
      </li>
    </ul>
  </li>
  <li>A few other minor changes and code cleanup;</li>
</ul>

<h3>Troubleshooting</h3>
<ol><li> First step is to check you're running CMS 1.12 or later.</li>
<li> Second step is to read and understand the caveat about WYSIWYG editors up in the
section <em>Adding a Browser to a Page</em>.</li>
<li> Read the note above about making sure your form has a FormBrowser Disposition!</li>
<li> Use unique ordering of fields in the Browser configuration. Using position 1 for two different fields, for example, will clobber one of the two.</li>
</ol>

<h3>Known Issues</h3>
<ul>
<li>FormBrowser does not yet support pretty urls</li>
<li>FormBrowser documentation is horrible. Someone should sponsor us to do a better job.</li>
</ul>

<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report, please visit the CMS Made Simple  <a href=\"http://dev.cmsmadesimple.org\">Developer Forge</a>.</li>
<li>To obtain commercial support, please send an email to the authors.</li>
<li>Additional discussion of this module may also be found in the <a href=\"http://forum.cmsmadesimple.org\">CMS Made Simple Forums</a>.</li>
<li>The authors can often be found in the <a href=\"irc://irc.freenode.net/#cms\">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the authors directly and grovelling for free support.</li>
</ul>

<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2015, Morten Poulsen<br />
Copyright &copy; 2009, Samuel Goldstein<br />
All Rights Are Reserved.</p>
<br />
<p>Developers: Fernando Morgado, Ryan Foster, Ruud van der Velden</p>
<br />
<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.</p>