<?php
#-------------------------------------------------------------------------
# Module: FormBrowser
# Author: Samuel Goldstein, Morten Poulsen
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2014 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/formbuilder
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!defined('CMS_VERSION')) exit;

$aebrowser = new fbrBrowser($this, $params, true);

if ($aebrowser->GetAttr('allow_user_delete','0')=='0')
{
	echo "<p>" . $this->Lang('accessdenied') . "</p>";
	return false;
}

$this->buildBrowseNav($id,$params,$returnid,true);
if (isset($params['response_id']))
{
	$aebrowser->DeleteResponse($params);
	$smarty->assign('fbrp_message',$this->Lang('deleted'));
	$parms = array();
	$parms['browser_name']=$aebrowser->GetName();
	$parms['record_id']=$params['response_id'];
	$parms['side']='user';
	$this->SendEvent('OnFormBrowserRecordDelete',$parms);
}
else
{
	$smarty->assign('fbrp_message','');
}
$aebrowser->BrowserShowList($id, $returnid,$this, $params,'list_fields');

echo $this->ProcessTemplateFromDatabase('fbr_ulist_'.$aebrowser->GetId());

#
# EOF
#
?>