<?php
#-------------------------------------------------------------------------
# Module: FormBrowser
# Author: Samuel Goldstein, Morten Poulsen
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2014 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/formbuilder
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!defined('CMS_VERSION')) exit;
if (!$this->CheckAccess()) exit;

$this->buildBrowseNav($id,$params,$returnid,false);
$smarty->assign('tab_headers',$this->StartTabHeaders().$this->SetTabHeader('administerformdata',$this->Lang('title_browsers')). $this->SetTabHeader('configuration',$this->Lang('title_configuration')).
				$this->EndTabHeaders().$this->StartTabContent());
$smarty->assign('end_tab',$this->EndTab());
$smarty->assign('tab_footers',$this->EndTabContent());
$smarty->assign('start_administerformdata_tab',$this->StartTab('administerformdata'));
$smarty->assign('start_configuration_tab',$this->StartTab('configuration'));
$smarty->assign('title_browser_name',$this->Lang('title_browser_name'));
$smarty->assign('title_browser_alias',$this->Lang('title_browser_alias'));
$smarty->assign('title_related_form',$this->Lang('title_related_form'));
$smarty->assign('title_browser_administer',$this->Lang('title_browser_administer'));
$smarty->assign('title_date_format',$this->Lang('title_date_format'));
$smarty->assign('title_strip_on_export',$this->Lang('title_strip_on_export'));
$smarty->assign('title_date_format_help',$this->Lang('title_date_format_help'));
$smarty->assign('title_browser_export',$this->Lang('title_browser_export'));
$smarty->assign('title_export_file',$this->Lang('title_export_file'));
$smarty->assign('title_section',$this->Lang('friendlyname'));
$smarty->assign('fbrp_message',isset($params['fbrp_message'])?$params['fbrp_message']:'');
$smarty->assign('title_export_file_encoding',$this->Lang('title_export_file_encoding'));
$smarty->assign('title_suppress_email_on_edit',$this->Lang('title_suppress_email_on_edit'));
$smarty->assign('title_show_response_id_in_export',$this->Lang('title_show_response_id_in_export'));

$admintheme = cms_utils::get_theme_object();

$browsers = $this->GetBrowsers();
//$num_browsers = count($browsers);
$browserArray = array();
//$currow = "row1";
foreach ($browsers as $thisBrowser) {
	$oneset = new stdClass();
	//$oneset->rowclass = $currow;
	if ($this->CheckPermission('Modify Browsers') || $this->CheckPermission('View Browsers')) {
		$oneset->name = $this->CreateLink($id, 'admin_add_edit_browser', '', $thisBrowser['name'], array('browser_id'=>$thisBrowser['browser_id']));
		$oneset->editlink = $this->CreateLink($id, 'admin_add_edit_browser', '', $admintheme->DisplayImage('icons/system/edit.gif',$this->Lang('edit'),'','','systemicon'),
			array('browser_id'=>$thisBrowser['browser_id']));
		$oneset->adminlink = $this->CreateLink($id, 'admin_browse', '', $admintheme->DisplayImage('icons/system/permissions.gif',$this->Lang('administrite'),'','','systemicon'),
			array('browser_id'=>$thisBrowser['browser_id']));
		$oneset->deletelink = $this->CreateLink($id, 'admin_delete_browser', '', $admintheme->DisplayImage('icons/system/delete.gif',$this->Lang('delete'),'','','systemicon'),
			array('browser_id'=>$thisBrowser['browser_id']), $this->Lang('are_you_sure_delete_browser',$thisBrowser['name']));
	} else {
		$oneset->name=$thisBrowser['name'];
		$oneset->editlink = '';
		$oneset->deletelink = '';
	}

	$oneset->form_name=$thisBrowser['form_name'];
	$oneset->exportlink = $this->CreateLink($id, 'admin_export_xls', '', '<img src="'.$this->config['root_url'].'/modules/FormBrowser/images/xls.gif" alt="'.$this->Lang('exporttoexcel').'"  title="'.$this->Lang('exporttoexcel').'" border="0" />',
		array('browser_id'=>$thisBrowser['browser_id']));

	$oneset->usage = $thisBrowser['alias'];
	array_push($browserArray, $oneset);
	//($currow == "row1"?$currow="row2":$currow="row1");

}

#########################################################################
# Assign to Smarty
#########################################################################

if ($this->CheckPermission('View Browsers')) {
	$smarty->assign('may_view',1);
} else {
	$smarty->assign('may_view',0);
}
if ($this->CheckPermission('Export Browsers')) {
	$smarty->assign('may_export',1);
} else {
	$smarty->assign('may_export',0);
}
if ($this->CheckPermission('Browse Records List')) {
	$smarty->assign('may_view_records_list',1);
} else {
	$smarty->assign('may_view_records_list',0);
}
if ($this->CheckPermission('Delete Browsers')) {
	$smarty->assign('may_delete',1);
} else {
	$smarty->assign('may_delete',0);
}
if ($this->CheckPermission('Config Form Browser')) {
	$smarty->assign('may_config',1);
} else {
	$smarty->assign('may_config',0);
	$smarty->assign('no_permission', $this->Lang('lackpermission'));
}
if ($this->CheckPermission('Modify Browsers') || $this->CheckPermission('Add Browsers')) {
	if ($this->CheckPermission('Modify Browsers')) {
		$smarty->assign('may_modify',1);
		// Give all other permissions so that "Modify Browsers" acts as a catch-all for now.
		$smarty->assign('may_add',1);
		$smarty->assign('may_view',1);
		$smarty->assign('may_export',1);
		$smarty->assign('may_view_records_list',1);
		$smarty->assign('may_delete',1);
		$smarty->assign('may_config',1);
	} else {
		$smarty->assign('may_modify',0);
	}
	$smarty->assign('may_add',1);
	$smarty->assign('addlink',$this->CreateLink($id, 'admin_add_edit_browser', '', $admintheme->DisplayImage('icons/system/newobject.gif',
			$this->Lang('title_add_new_browser'),'','','systemicon'), array()));
	$smarty->assign('addbrowser',$this->CreateLink($id, 'admin_add_edit_browser', '', $this->Lang('title_add_new_browser'), array()));
} else {
	$smarty->assign('may_add',0);
	$smarty->assign('no_permission', $this->Lang('lackpermission'));
}

$smarty->assign('browser_count',count($browsers));
$smarty->assign('browsers', $browserArray);
$smarty->assign('mod', $this);

$smarty->assign('start_configform',$this->CreateFormStart($id, 'admin_store_config', $returnid));
$smarty->assign('end_configform',$this->CreateFormEnd());
$smarty->assign('input_date_format',$this->CreateInputText($id, 'fbrp_date_format', $this->GetPreference('date_format','d F y'), 20, 255));

$smarty->assign('input_suppress_email_on_edit', $this->CreateInputHidden($id,'fbrp_suppress_email_on_edit','0'). $this->CreateInputCheckbox($id, 'fbrp_suppress_email_on_edit', '1',
				$this->GetPreference('suppress_email_on_edit','1')).$this->Lang('help_suppress_email_on_edit'));

$smarty->assign('input_show_response_id_in_export', $this->CreateInputHidden($id,'fbrp_show_response_id_in_export','0'). 
				$this->CreateInputCheckbox($id, 'fbrp_show_response_id_in_export', '1', $this->GetPreference('show_response_id_in_export','0')). 
				$this->Lang('title_show_response_id_in_export_long'));

$smarty->assign('input_strip_on_export', $this->CreateInputHidden($id,'fbrp_strip_on_export','0'). $this->CreateInputCheckbox($id, 'fbrp_strip_on_export', '1',
				$this->GetPreference('strip_on_export','0')). $this->Lang('title_strip_on_export_long'));
$smarty->assign('input_export_file', $this->CreateInputHidden($id,'fbrp_export_file','0'). $this->CreateInputCheckbox($id, 'fbrp_export_file', '1',
				$this->GetPreference('export_file','0')). $this->Lang('title_export_file_long'));

$separator = $this->GetPreference('csv_separator', ',');
$enclosure = $this->GetPreference('csv_enclosure', '"');

$smarty->assign('input_separator', $this->CreateInputText($id, 'separator', $separator, 50));
$smarty->assign('input_enclosure', $this->CreateInputText($id, 'enclosure', $enclosure, 50));
// probably to be removed (JM)
$encodings = array('utf-8'=>'utf-8','windows-1252'=>'windows-1252', 'iso-8859-1'=>'iso-8859-1');
$smarty->assign('input_export_file_encoding', $this->CreateInputRadioGroup($id, 'fbrp_export_file_encoding', $encodings, $this->GetPreference('export_file_encoding','iso-8859-1'), '', '<br />'));
// --->>
$smarty->assign('submit', $this->CreateInputSubmit($id, 'fbrp_submit', $this->Lang('save')));

echo $this->ProcessTemplate('adminpanel.tpl');

#
# EOF
#
?>