<?php
#-------------------------------------------------------------------------
# Module: FormBrowser
# Author: Samuel Goldstein, Morten Poulsen
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2014 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/formbuilder
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!defined('CMS_VERSION')) exit;

// handle human readable fields
if (isset($params['browser']) && ! isset($params['fbrp_browser_alias']))
{
	$params['fbrp_browser_alias']=$params['browser'];
	$params['fbrp_load']=true;
}

// Some required functions
require_once(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'libraries' . DIRECTORY_SEPARATOR . 'core.functions.php');

if(isset($params['fbrp_searchfield']))
{
	$fbrp_arr_getfield = array();
	$fbrp_arr_searchfield = explode(',', $params['fbrp_searchfield']);
	$smarty->assign_by_ref('fbrp_arr_searchfield', $fbrp_arr_searchfield);

	$smarty->assign('fbrp_startfbrsearchform', $this->CreateFormStart($id, 'default', $returnid, 'get', '', true));
	$_submit = (isset($params['fbrp_searchsubmit'])) ? $params['fbrp_searchsubmit'] : $this->Lang('fbrp_searchsubmit');
	$smarty->assign('submitbutton', $this->CreateInputSubmit($id, 'fbrp_searchsubmit', $_submit));
	$smarty->assign('fbrp_endfbrsearchform', $this->CreateFormEnd());

	$fb_form_id = GetFormIdFromName($params['browser']);
	if($fb_form_id !== false)
	{
		foreach($fbrp_arr_searchfield as $_field)
		{
			if ((! empty($_GET[$_field])) && (empty($params[$_field])))
			{
				$params[$_field] = $_GET[$_field];
			}
			if(! empty($params[$_field]))
			{
				$fb_field_id = GetFieldId($fb_form_id, $_field);
				if($fb_field_id !== false)
				{
					$fbrp_arr_getfield[$_field] = array('id'=>$fb_field_id, 'value'=>htmlspecialchars($params[$_field]));
				}
			}
			$params['fbrp_arr_getfield']= $fbrp_arr_getfield;
			$smarty->assign_by_ref('fbrp_arr_getfield', $fbrp_arr_getfield);
		}
	}

	$fbrp_response_search = GetRespId($fbrp_arr_getfield);
	$params['fbrp_response_search']= $fbrp_response_search;
}


if (isset($params['sort_field']) && ! isset($params['fbrp_sort_field']))
{
	$params['fbrp_sort_field'] = $params['sort_field'];
}
if (isset($params['sort_dir']) && ! isset($params['fbrp_sort_dir']))
{
	$params['fbrp_sort_dir'] = $params['sort_dir'];
}

$br = new fbrBrowser($this, $params, true);

$br->BrowserShowList($id,$returnid,$this,$params,'list_fields');
$smarty->assign('in_admin',0);
$smarty->assign('in_formbrowser',1);

echo $this->ProcessTemplateFromDatabase('fbr_ulist_'.$br->GetId());

#
# EOF
#
?>