<?php
#-------------------------------------------------------------------------
# Module: FormBrowser
# Author: Samuel Goldstein, Morten Poulsen
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2014 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/formbuilder
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------
if (!defined('CMS_VERSION')) exit;
if (!$this->CheckAccess('Export Browsers')) exit;

// Clear output buffer
$handlers = ob_list_handlers();
for ($cnt = 0; $cnt < sizeof($handlers); $cnt++) { ob_end_clean(); }

$aebrowser = new fbrBrowser($this, $params, true);

$datestr = date('Y-m-d');
$sname = preg_replace( '/\W/', '_', $aebrowser->GetName() );
$spec = $this->Lang( 'export_spec', array($sname, $datestr) );

if ($this->GetPreference('export_file','0') == '1')
{
	$params['filespec']=$spec;
	$config = cmsms()->getConfig();
	$url= $config['uploads_url'] . '/' . $spec;

	if ($aebrowser->BrowserShowListXLSFile( $this, $params) )
	{
		header('Location: ' . $url);
		exit;
	}
}

$reportString = $aebrowser->BrowserShowListXLS($this, $params);
$encoding = $this->GetPreference('export_file_encoding', 'iso-8859-1');// CSV standard, believe it or not !?

header('Pragma: public');
header('Expires: 0');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Cache-Control: private',false);
header('Content-Description: File Transfer');
header('Content-Type: text/csv');
//header('Content-type:text/csv; charset=iso8859-1');
header('Content-Type: text/csv; charset=' . $encoding);
header('Content-Length: ' . strlen($reportString));
header('Content-Disposition: attachment; filename=' . $spec);
// just testing some encoding exports: seems good so far... (JM)
if($encoding = 'utf-8') $reportString = utf8_encode($reportString);
if($encoding = 'windows-1252') $reportString = mb_convert_encoding($reportString, 'windows-1252', 'iso-8859-1');
echo $reportString;
exit;

#
# EOF
#
?>