<?php
#-------------------------------------------------------------------------
# Module: FormBrowser
# Author: Samuel Goldstein, Morten Poulsen
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2014 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/formbuilder
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!defined('CMS_VERSION')) exit;
if (!$this->CheckAccess('Browse Records List')) exit;

$aebrowser = new fbrBrowser($this, $params, true);
$this->buildBrowseNav($id,$params,$returnid,false);
$aebrowser->BrowserShowList($id, $returnid,$this, $params,'admin_list_fields',true);

$parms = array();
$parms['browser_id']=$aebrowser->GetId();
$parms['form_id']=$aebrowser->GetFormId();
$parms['fbrp_sort_field']=(isset($params['fbrp_sort_field'])?$params['fbrp_sort_field']:'');
$parms['fbrp_sort_dir']=(isset($params['fbrp_sort_dir'])?$params['fbrp_sort_dir']:'d');

$smarty->assign('form_start',$this->CreateFormStart($id, 'admin_delete_resp', $returnid, 'post', '', '', '', $parms));
if ($this->CheckPermission('Delete Records') || $this->CheckPermission('Modify Browsers')) {
	$smarty->assign('delete',$this->CreateInputSubmit($id, 'delete', $this->Lang('delete'), '', '', $this->Lang('delete_selected_records')));
} else {
	$smarty->assign('delete','');
}
$smarty->assign('in_admin',1);
$smarty->assign('in_formbrowser',1);
if ($this->CheckPermission('Browse Records Full') || $this->CheckPermission('Modify Browsers')) {
	$smarty->assign('may_view_records_full',1);
} else {
	$smarty->assign('may_view_records_full',0);
}

echo $this->ProcessTemplateFromDatabase('fbr_alist_'.$aebrowser->GetId());

#
# EOF
#
?>