<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
# Method: Upgrade
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$db = $this->GetDb();
$taboptarray = array('mysql' => 'ENGINE=MyISAM');
$dict = NewDataDictionary($db);

switch( $oldversion )
{
	case "1.0":
	case "1.0.1":
		$this->SetPreference('send_notifications_to', get_userid());
		$this->SetPreference('custom_modulename', $this->Lang('friendlyname'));
		$this->SetPreference('admin_section', 'content');

		//current_version: 1.1

	case "1.1":
		$this->CreateEvent('Gbook_entry_deleted');
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix()."module_gbook_entries", "spamrate I");
		$dict->ExecuteSQLArray($sqlarray);

		//current_version: 1.2
		
	case "1.2":
		if ( $this->GetPreference('send_notifications_to') == '' )
		{
			$send_notifications_to[0] = get_userid();
			$this->SetPreference('send_notifications_to', serialize($send_notifications_to));
		}

		//current_version: 2.0
		
	case "2.0":
	case "2.0.1":
	case "2.0.2":
	case "2.0.3":
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix() . "module_gbook", "use_captcha L DEFAULT '0', allow_rating L DEFAULT '0'");
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix() . "module_gbook_entries", "rating I");
		$dict->ExecuteSQLArray($sqlarray);
		
	case "2.1":
		@unlink('../modules/Gbook/images/icon.gif');
		// add honeypot to all formtemplates
		$tpls = $this->ListTemplates();
		foreach( $tpls as $tpl )
		{
			if ( substr($tpl, 0, 4) == 'form' )
			{
				$tpl_cnt = $this->GetTemplate($tpl);
				if ( strpos($tpl_cnt, '{$gbook_honeypot_input}') === false )
				{
					$tpl_rpl = '{$gbook_startform}' . "\n\n{* honeypot do not remove *}<style type=\"text/css\">\n.gbook_website { position: absolute; left: -500em; }\n</style>\n<div class=\"gbook_field gbook_website\">\n	" . '<label for="{$gbook_formid}website">Website</label>{$gbook_honeypot_input}' . "\n</div>{* end honeypot *}\n";
					$tpl_cnt = str_replace('{$gbook_startform}', $tpl_rpl, $tpl_cnt);
					$this->SetTemplate($tpl, $tpl_cnt);
				}
			}
		}

		//current_version: 2.2
		
}

?>