<?php 
#-------------------------------------------------------------------------
# Module: SimpleSiteInfo
# Author: Noel McGran, Rolf Tjassens
#-------------------------------------------------------------------------
# CMS Made Simple is (c) 2004 - 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# CMS Made Simple is (c) 2011 - 2016 by The CMSMS Dev Team
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/simplesiteinfo
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if ( !cmsms() ) exit;

class SimpleSiteInfo extends CMSModule {

	function GetName(){ return 'SimpleSiteInfo'; }
	function GetFriendlyName(){ return $this->Lang('friendlyname'); }
	function GetVersion(){ return '3.0'; }
	function GetHelp() { return file_get_contents(dirname(__FILE__).'/help_text.inc'); }
	function GetAuthor(){ return 'Noel McGran, Rolf Tjassens'; }
	function GetAuthorEmail(){ return 'nmcgran@telus.net, rolf at cmsmadesimple dot org'; }
	function GetChangeLog() { return file_get_contents(dirname(__FILE__).'/changelog.inc'); }
	function SetParameters(){ $this->RestrictUnknownParams(); }
	function IsPluginModule(){ return true; }
	function HasAdmin(){ return true; }
	function GetAdminSection(){ return 'siteadmin'; }
	function GetAdminDescription(){ return $this->Lang('moddescription'); }
	function VisibleToAdminUser(){ return ($this->CheckPermission('Modify Site Preferences') || $this->CheckPermission('Modify Modules')); }
	function GetDependencies(){ return array(); }
	function MinimumCMSVersion(){ return "2.0"; }
	function InstallPostMessage(){ return $this->Lang('postinstall'); }
	function UninstallPostMessage(){ return $this->Lang('postuninstall'); }
	
	function NB_Encryption($string, $key){
   		$TD = mcrypt_module_open('tripledes', '', 'ecb', '');
   		$IV = mcrypt_create_iv (mcrypt_enc_get_iv_size($TD), MCRYPT_RAND);
   		mcrypt_generic_init($TD, $key, $IV);
   		$encrypted_data = mcrypt_generic($TD, $string);
   		mcrypt_generic_deinit($TD);
   		mcrypt_module_close($TD);
   		return $encrypted_data;
	}
	
	function UpdateInfoFile(){
		// Basic Setup
		global $CMS_VERSION;
		$db = cmsms()->GetDb();
		$config = cmsms()->GetConfig();
		$admin_url = $config['root_url'].'/'.$config['admin_dir'];
		$php_version = phpversion();

		// Password query
		$query = "SELECT * FROM ".cms_db_prefix()."siteprefs WHERE sitepref_name LIKE 'SimpleSiteInfo%'";
		$dbresult = $db->Execute($query);
		$row = $dbresult->FetchRow();
		$version_file_pwd = $row['sitepref_value'];

		// Output File Setup
		$create_write = @fopen((cmsms()->config["root_path"] . "/tmp/siteinfo.txt"), 'w') or die("ERROR SimpleSiteInfo module: Can't create or open version file!!");

		// Output Start
		$file_out  = "CMSMS*\n";
		$file_out .= $admin_url . "*\n";
		$file_out .= $CMS_VERSION . "*\n";
		$file_out .= $php_version . "*\n";

		// Module Query
		$query = "SELECT * FROM ".cms_db_prefix()."modules WHERE active=1 ORDER BY module_name ASC";
		$dbresult = $db->Execute($query);

		while($dbresult && $row = $dbresult->FetchRow()) {
   			$file_out .= $row['module_name'] . "," .$row['version'] . "|\n";
		}

		$file_enc = $this->NB_Encryption($file_out,$version_file_pwd);

		fwrite($create_write, $file_enc);
		fclose($create_write);
	}
}

?>