<?php
if (!isset($gCms)) exit;

// Check permissions
if( !$this->CheckPermission('Gbook: Use') )
{
	echo $this->ShowErrors(lang('needpermissionto', 'Gbook: Use'));
	return;
}

if( !isset($params['gbookid']) )
{
	$params = array('errors' => lang('missingparams'), 'active_tab' => 'items');
	$this->Redirect($id, 'defaultadmin', '', $params);
	return;
}

if( !isset($params['multiaction']) || empty($params['multiselect']) )
{
	$params = array('errors' => lang('missingparams'), 'active_tab' => 'items', 'gbookid' => $params['gbookid'], 'filter' => $params['filter']);
	$this->Redirect($id, 'defaultadmin', '', $params);
	return;
}

$itemid_array = array_keys($params['multiselect']);
$itemids = implode(',',$itemid_array);

switch( $params['multiaction'] )
{
	case 'delete':
	{
		$query = "DELETE FROM " . cms_db_prefix() . "module_gbook_entries WHERE entry_id IN (" . $itemids . ")";
		$db->Execute($query);

		$search = cms_utils::get_module('Search');
		foreach( $itemid_array as $itemid )
		{
			//Update search index
			if ( $search != false )
			{
				$search->DeleteWords($this->GetName(), $itemid, 'entry');
			}
			//Send event
			$this->SendEvent('Gbook_entry_deleted', array('entry_id' => $itemid, 'gbookid' => $params['gbookid']));
		}
		break;
	}

	case 'active':
	{
		$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET active = 1 WHERE entry_id IN (" . $itemids . ")";
		$db->Execute($query);
		
		$search = cms_utils::get_module('Search');
		foreach( $itemid_array as $itemid )
		{
			//Update search index
			if ( $search != false )
			{
				$item = Gbook_utils::GetEntry($itemid);
				$search->AddWords($this->GetName(), $itemid, 'entry', $item->title . ' ' . $item->message);
			}
			//Send event
			$this->SendEvent('Gbook_entry_edited', array('entry_id' => $itemid, 'gbookid' => $params['gbookid'], 'active' => 1));
		}
		break;
	}

	case 'inactive':
	{
		$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET active = 0 WHERE entry_id IN (" . $itemids . ")";
		$db->Execute($query);
		
		$search = cms_utils::get_module('Search');
		foreach( $itemid_array as $itemid )
		{
			//Update search index
			if ( $search != false )
			{
				$search->DeleteWords($this->GetName(), $itemid, 'entry');
			}
			//Send event
			$this->SendEvent('Gbook_entry_edited', array('entry_id' => $itemid, 'gbookid' => $params['gbookid'], 'active' => 0));
		}
		break;
	}

}


$params = array('active_tab' => 'items', 'gbookid' => $params['gbookid'], 'filter' => $params['filter']);
$this->Redirect($id, 'defaultadmin', $returnid, $params);
?>