<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

// handle the page to go to after cancel or submit.
$dest_page = $returnid;
$redirect = $this->GetPreference('form_redirect');
if( !empty($redirect) )
{
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($redirect);
	if (isset($node))
	{
		$dest_page = $node->getID();
	}
	else
	{
		$node =& $manager->sureGetNodeById($redirect);
		if (isset($node))
		{
			$dest_page = $redirect;
		}
	}
}

if( isset($params['cancel']) )
{
	$this->RedirectContent($dest_page);
}

// Get gbook properties
$alias = empty($params['alias']) ? $this->GetPreference('defaultgbook') : $params['alias'];
$gbooks = Gbook_utils::GetGbooks($alias);
$gbook = $gbooks[0];

if ( empty($gbook) )
{
	$this->RedirectContent($dest_page);
}

// token
$token = $this->GetPreference('gbook_token', 's:0:"";');
$token = unserialize($token);
$tokentimestamp = ceil(time()/60/5);
if ( empty($token[$tokentimestamp]) ) 
{
	$token[$tokentimestamp] = md5(rand());
	$token = array_intersect_key($token, array($tokentimestamp-2=>0,$tokentimestamp-1=>0,$tokentimestamp=>0));
	$this->SetPreference('gbook_token', serialize($token));
}

$showform = true;
$fielderrors = array();
$fields = array('name', 'email', 'title', 'message');
foreach ( $fields as $field )
{
	$params[$field] = empty($params[$field]) ? '' : html_entity_decode($params[$field],ENT_QUOTES);
}
$params['notify'] = empty($params['notify']) ? 0 : 1;

// process form submission
if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset($params['submit']) )
{
	$showform = false;
	
	// check token
	$receivedtoken = explode('-', $params['token']);
	if ( array_key_exists($receivedtoken[0], $token) && $receivedtoken[1] == md5($gbook['gbook_id'] . $token[$receivedtoken[0]]) )
	{
		$addentry = Gbook_utils::AddEntry($gbook['gbook_id'], $params['name'], $params['email'], $params['title'], $params['message'], $params['notify']);

		if ( is_array($addentry) && key($addentry) == 'entry added' )
		{
			// entry added succesfully
			
			//$entry_id = $addentry['entry added'][0];
			$spamrate = $addentry['entry added'][1];
			if ( $spamrate <= $this->GetPreference('max_spamrate_notify', 0.9) )
			{
				// send email to admin
				$cmsmailer = cms_utils::get_module('CMSMailer');
				$users = (array)unserialize($this->GetPreference('send_notifications_to'));
				if( $cmsmailer && !empty($users) )
				{
					foreach ( $users as $user )
					{
						if ( $user < 0 )
						{
							// group
							$groupusers = cmsms()->GetUserOperations()->LoadUsersInGroup(abs($user));
							foreach ( $groupusers as $groupuser)
							{
								if ( $groupuser->active ) $cmsmailer->AddAddress($groupuser->email);
							}
						}
						else
						{
							// individual user
							$user_email = cmsms()->GetUserOperations()->LoadUserById($user)->email;
							$cmsmailer->AddAddress($user_email);
						}
					}
					$cmsmailer->SetSubject($gbook['admin_notification_subject']);
					$cmsmailer->IsHTML(false);
					$body = $smarty->fetch('string:'.$gbook['admin_notification_message']);
					$cmsmailer->SetBody($body);
					$cmsmailer->Send();
					$cmsmailer->ClearAddresses();
				}				
			}
			
			// display submission response
			$response = ($spamrate <= $this->GetPreference('max_spamrate_active', 0.6)) ? 'submission_response' : 'submission_response_spam';
			echo $smarty->display('string:'.$gbook[$response]);
		}
		elseif ( is_array($addentry) )
		{
			// AddEntry not succeeded
			
			$default_message = '<p>We are realy sorry for this inconvenience.</p><p>Please try again later, or send us an email so we can add your message to our website on your behalf.</p>';
			switch ( key($addentry) )
			{
				case 'double post':
					echo $this->Lang('double_post');
					break;

				case 'not allowed to post twice':
					echo $this->Lang('not_allowed_to_post_twice');
					break;

				case 'gbook not found':
					echo '<p><b>Error: ' . __LINE__ . '</b> »  For some unknown reason the list you are trying to post to, could not be found. Maybe it doesn\'t exist anymore?</p>' . $default_message;
					break;

				case 'mysql error':
					echo '<p><b>Error: ' . __LINE__ . '</b> »  For some unknown reason your message could not be saved to the database.</p>' . $default_message;
					break;

				case 'spam':
					echo '<p>Thank you for your kind feedback. You will be redirected to the page you came from.</p>';
					$this->RedirectContent($dest_page);
					exit();
					break;

				case 'field validation errors':
					$fielderrors = $addentry['field validation errors'];
					$showform = true;
					break;

				default:
					echo '<p><b>Error: ' . __LINE__ . '</b> »  Something must have gone wrong for an unknown reason.</p>' . $default_message;
					break;
			}
		}
		else
		{
			echo '<p><b>Error: ' . __LINE__ . '</b> »  Something must have gone wrong for an unknown reason. You will be redirected to the page you came from.</p>';
			$this->RedirectContent($dest_page);
			exit();
		}

	}
	else
	{
		// token not valid, do nothing and send back to dest_page
		echo '<h1>Gbook Token Not Valid</h1>';
		$this->RedirectContent($dest_page);
	}

}


if ( $showform )
{
	// build the form
	$smarty->assign('gbook_name', $gbook['name']);
	$smarty->assign('gbook_formid', $id);
	
	$smarty->assign('gbook_errormessage', empty($fielderrors) ? '' : $this->Lang('validation_errors'));
	$smarty->assign('gbook_startform', $this->CreateFrontEndFormStart($id, $returnid, 'form', 'post', 'multipart/form-data', true, '', array('alias' => $gbook['gbook_id'], 'token' => $tokentimestamp . '-' . md5($gbook['gbook_id'] . $token[$tokentimestamp]) )));
	$smarty->assign('gbook_endform', $this->CreateFormEnd());

	$smarty->assign('gbook_name_label', $this->Lang('name'));
	$smarty->assign('gbook_name_field', $id . 'name');
	$smarty->assign('gbook_name_input', $this->CreateInputText($id, 'name', html_entity_decode($params['name'],ENT_QUOTES), 40, 255));
	$smarty->assign('gbook_name_error', in_array('name', $fielderrors) ? 1 : '');

	$smarty->assign('gbook_email_label', $this->Lang('email'));
	$smarty->assign('gbook_email_field', $id . 'email');
	$smarty->assign('gbook_email_input', $this->CreateInputText($id, 'email', html_entity_decode($params['email'],ENT_QUOTES), 40, 255));
	$smarty->assign('gbook_email_error', in_array('email', $fielderrors) ? 1 : '');

	$smarty->assign('gbook_title_label', $this->Lang('title'));
	$smarty->assign('gbook_title_field', $id . 'title');
	$smarty->assign('gbook_title_input', $this->CreateInputText($id, 'title', html_entity_decode($params['title'],ENT_QUOTES), 40, 255));
	$smarty->assign('gbook_title_error', in_array('title', $fielderrors) ? 1 : '');

	$smarty->assign('gbook_message_label', $this->Lang('message'));
	$smarty->assign('gbook_message_field', $id . 'message');
	$smarty->assign('gbook_message_input', $this->CreateTextArea(false, $id, html_entity_decode($params['message'],ENT_QUOTES), 'message', '', $id . 'message'));
	$smarty->assign('gbook_message_error', in_array('message', $fielderrors) ? 1 : '');

	if ( $gbook['allow_smilies'] )
	{
		$smarty->assign('gbook_smileys', Gbook_utils::GetSmileys());
	}

	if ( $gbook['allow_notifications'] )
	{
		$smarty->assign('gbook_notify_label', $this->Lang('notify'));
		$smarty->assign('gbook_notify_field', $id . 'notify');
		$smarty->assign('gbook_notify_input', $this->CreateInputCheckbox($id, 'notify', 1, $params['notify'], 'id="' . $id . 'notify"'));
	}
	
	$smarty->assign('gbook_submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('fe_submit')));

	

	$template = $this->GetPreference('default_form_template');
	if ( !empty($params['template']) )
	{
		$template = 'form_tpl_' . $params['template'];
	}
		
	echo $this->ProcessTemplateFromDatabase($template);
}

?>