<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if( !$gCms ) exit();

if( !$this->CheckPermission('Gbook: Modify') )
{
	echo $this->ShowErrors(lang('needpermissionto', 'Gbook: Modify'));
	return;
}

if ( isset($params['cancel']) )
{
	$params = array('active_tab' => 'gbooks');
	$this->Redirect($id, 'defaultadmin', '', $params);
}

if( !isset($params['mode']) )
{
	$params = array('errors' => lang('missingparams'), 'active_tab' => 'gbooks');
	$this->Redirect($id, 'defaultadmin', '', $params);
	return;
}

if ( !function_exists('str_getcsv') )
{
	// php version < 5.3
	function str_getcsv($input, $delimiter = ';', $enclosure = '"', $escape='\\'){
			$fields = explode($enclosure . $delimiter . $enclosure, trim($input, $enclosure));
			foreach ($fields as $key=>$value)
					$fields[$key] = str_replace($escape . $enclosure, $enclosure, $value);
			return($fields);
	}
}

switch ($params['mode'])
{
	case 'add':
		if( $_SERVER['REQUEST_METHOD'] == 'POST' )
		{
			$params['prevent_post_twice'] = empty($params['prevent_post_twice']) ? 0 : 1;
			$params['allow_smilies'] = empty($params['allow_smilies']) ? 0 : 1;
			$params['allow_notifications'] = empty($params['allow_notifications']) ? 0 : 1;
			$params['notification_subject'] = '';
			$params['notification_message'] = '';
			$params['required_fields'] = empty($params['required_fields']) ? '' : implode(',', $params['required_fields']);
			$params['active'] = empty($params['active']) ? 0 : 1;

			$query = "INSERT INTO ".cms_db_prefix()."module_gbook (
									name, 
									alias, 
									entries_page,
									prevent_post_twice,
									allow_smilies, 
									allow_notifications, 
									notification_subject,
									notification_message,
									submission_response,
									submission_response_spam,
									admin_notification_subject,
									admin_notification_message,
									required_fields,
									active) 
								VALUES 
									(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			$result = $db->Execute($query, array(
					$params['name'], 
					strtolower(munge_string_to_url($params['name'])), 
					$params['entries_page'], 
					$params['prevent_post_twice'],
					$params['allow_smilies'],
					$params['allow_notifications'], 
					$params['notification_subject'], 
					$params['notification_message'], 
					$params['submission_response'], 
					$params['submission_response_spam'], 
					$params['admin_notification_subject'], 
					$params['admin_notification_message'], 
					$params['required_fields'],
					$params['active']
				));

			$params = array('tab_message'=> 'gbookadded', 'active_tab' => 'gbooks');
			$this->Redirect($id, 'defaultadmin', '', $params);
		}
		else
		{
			$params['gbookid'] = 0;
			$gbook['name'] = '';
			$gbook['entries_page'] = 10;
			$gbook['prevent_post_twice'] = 0;
			$gbook['allow_smilies'] = 1;
			$gbook['allow_notifications'] = 1;
			$gbook['notification_subject'] = '';
			$gbook['notification_message'] = '';
			$gbook['submission_response'] = $this->Lang('submission_response_cnt');
			$gbook['submission_response_spam'] = $this->Lang('submission_response_spam_cnt');
			$gbook['admin_notification_subject'] = $this->Lang('admin_notification_subject_cnt');
			$gbook['admin_notification_message'] = $this->Lang('admin_notification_message_cnt');
			$gbook['required_fields'] = '';
			$gbook['active'] = 1;
		}
		$smarty->assign('title',$this->Lang('addgbook'));
		break;


	case 'delete':
		if( !isset($params['gbookid']) )
		{
			$params = array('errors' => lang('missingparams'), 'active_tab' => 'gbooks');
			$this->Redirect($id,'defaultadmin','',$params);
			return;
		}

		$query = "DELETE FROM " . cms_db_prefix() . "module_gbook_entries WHERE gbook_id = ?";
		$db->Execute($query, array($params['gbookid']));

		$query = "DELETE FROM " . cms_db_prefix() . "module_gbook WHERE gbook_id = ?";
		$db->Execute($query, array($params['gbookid']));

		$params = array('tab_message'=> 'gbookdeleted', 'active_tab' => 'gbooks');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;


	case 'switchactive':
		$query = "UPDATE " . cms_db_prefix() . "module_gbook SET active = active^1 WHERE gbook_id = ?";
		$db->Execute($query, array($params['gbookid']));

		$params = array('tab_message'=> 'gbookupdated', 'active_tab' => 'gbooks');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;


	case 'switchdefault':
		$this->SetPreference('defaultgbook', $params['gbookid']);

		$params = array('tab_message'=> 'gbookupdated', 'active_tab' => 'gbooks');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;


	case 'edit':
		if( !isset($params['gbookid']) )
		{
			$params = array('errors' => lang('missingparams'), 'active_tab' => 'gbooks');
			$this->Redirect($id,'defaultadmin','',$params);
			return;
		}

		if( $_SERVER['REQUEST_METHOD'] == 'POST' )
		{
			$params['prevent_post_twice'] = empty($params['prevent_post_twice']) ? 0 : 1;
			$params['allow_smilies'] = empty($params['allow_smilies']) ? 0 : 1;
			$params['allow_notifications'] = empty($params['allow_notifications']) ? 0 : 1;
			$params['notification_subject'] = '';
			$params['notification_message'] = '';
			$params['required_fields'] = empty($params['required_fields']) ? '' : implode(',', $params['required_fields']);
			$params['active'] = empty($params['active']) ? 0 : 1;
			$query = "UPDATE " . cms_db_prefix() . "module_gbook SET 
									name = ?, 
									alias = ?, 
									entries_page = ?, 
									prevent_post_twice = ?,
									allow_smilies = ?, 
									allow_notifications = ?, 
									notification_subject = ?,
									notification_message = ?,
									submission_response = ?,
									submission_response_spam = ?,
									admin_notification_subject = ?,
									admin_notification_message = ?,
									required_fields = ?,
									active = ? 
								WHERE 
									gbook_id = ?";
			$result = $db->Execute($query, array(
					$params['name'], 
					strtolower(munge_string_to_url($params['name'])), 
					$params['entries_page'], 
					$params['prevent_post_twice'],
					$params['allow_smilies'], 
					$params['allow_notifications'], 
					$params['notification_subject'], 
					$params['notification_message'], 
					$params['submission_response'], 
					$params['submission_response_spam'], 
					$params['admin_notification_subject'], 
					$params['admin_notification_message'], 
					$params['required_fields'], 
					$params['active'], 
					$params['gbookid']
				));

			// import csv
			$fieldname = $id . "import_csv";
			if ( isset($_FILES) && isset($_FILES[$fieldname]) && is_array($_FILES[$fieldname]) && $_FILES[$fieldname]['name'])
			{
				$query = "INSERT INTO " . cms_db_prefix() . "module_gbook_entries 
										(gbook_id, name, email, title, message, notify, ip, create_date, modified_date, activation_code, active)
									VALUES
										(?, ?, ?, ?, ?, 0, ?, ?, NOW(), '', 1)";
				$file = $_FILES[$fieldname];
				$filecontent = file_get_contents($file['tmp_name']);
				$filecontent = str_replace("\r\n", "\n", $filecontent);
				$filecontent = str_replace("\n\r", "\n", $filecontent);
				$filecontent = str_replace(';;', ';"";', $filecontent);
				$csvdata = str_getcsv($filecontent, "\n"); //parse the rows
				$search = cms_utils::get_module('Search');
				foreach($csvdata as $row) 
				{
					$csvrow = str_getcsv($row, ";"); //parse the items in rows
					for ($i = 0; $i < 4; $i++) {
						$csvrow[$i] = stripslashes($csvrow[$i]);
						$csvrow[$i] = html_entity_decode($csvrow[$i],ENT_QUOTES);
						$csvrow[$i] = utf8_encode($csvrow[$i]);
						if ( $i < 3 ) $csvrow[$i] = strip_tags($csvrow[$i]);
					}
					$result = $db->Execute($query, array($params['gbookid'], $csvrow[0], $csvrow[1], $csvrow[2], $csvrow[3], $csvrow[4], $csvrow[5]));
					//Update search index
					if ( $search != false )
					{
						$search->AddWords($this->GetName(), $db->Insert_ID(), 'entry', $csvrow[2] . ' ' . $csvrow[3]);
					}
				}
			}
			
			$params = array('tab_message'=> 'gbookupdated', 'active_tab' => 'gbooks');
			$this->Redirect($id, 'defaultadmin', '', $params);
		}
		else
		{
			$gbooks = Gbook_utils::GetGbooks($params['gbookid'], false);
			$gbook = $gbooks[0];
		}
		$smarty->assign('title',$this->Lang('editgbook'));
}

$smarty->assign('prompt_name',lang('name'));
$smarty->assign('name', $this->CreateInputText($id, 'name', $gbook['name'], 40 ));

$smarty->assign('prompt_entries_page',$this->Lang('entries_page'));
$smarty->assign('entries_page', $this->CreateInputText($id, 'entries_page', $gbook['entries_page'], 4 ));

$smarty->assign('prompt_prevent_post_twice',$this->Lang('prevent_post_twice'));
$smarty->assign('prevent_post_twice', $this->CreateInputCheckbox( $id, 'prevent_post_twice', 1, $gbook['prevent_post_twice']));

$smarty->assign('prompt_allow_smilies',$this->Lang('allow_smilies'));
$smarty->assign('allow_smilies', $this->CreateInputCheckbox( $id, 'allow_smilies', 1, $gbook['allow_smilies']));

$smarty->assign('prompt_allow_notifications',$this->Lang('allow_notifications'));
$smarty->assign('allow_notifications', $this->CreateInputCheckbox($id, 'allow_notifications', 1, $gbook['allow_notifications']));

$smarty->assign('prompt_notification_subject',$this->Lang('notification_subject'));
$smarty->assign('notification_subject', $this->CreateInputText($id, 'notification_subject', $gbook['notification_subject'], 60 ));

$smarty->assign('prompt_notification_message',$this->Lang('notification_message'));
$smarty->assign('notification_message', $this->CreateTextArea(false, $id, $gbook['notification_message'], 'notification_message'));

$smarty->assign('prompt_submission_response',$this->Lang('submission_response'));
$smarty->assign('submission_response', $this->CreateTextArea(true, $id, $gbook['submission_response'], 'submission_response'));

$smarty->assign('prompt_submission_response_spam',$this->Lang('submission_response_spam'));
$smarty->assign('submission_response_spam', $this->CreateTextArea(true, $id, $gbook['submission_response_spam'], 'submission_response_spam'));

$smarty->assign('prompt_admin_notification_subject',$this->Lang('admin_notification_subject'));
$smarty->assign('admin_notification_subject', $this->CreateInputText($id, 'admin_notification_subject', $gbook['admin_notification_subject'], 60 ));

$smarty->assign('prompt_admin_notification_message',$this->Lang('admin_notification_message'));
$smarty->assign('admin_notification_message', $this->CreateTextArea(false, $id, $gbook['admin_notification_message'], 'admin_notification_message'));

$smarty->assign('prompt_required_fields',$this->Lang('required_fields'));
$smarty->assign('required_fields', 
				$this->CreateInputCheckbox($id, 'required_fields[]', 'name', strpos(' ' . $gbook['required_fields'], 'name') ? 'name' : '') . ' ' . $this->Lang('name') . '<br />' .
				$this->CreateInputCheckbox($id, 'required_fields[]', 'email', strpos(' ' . $gbook['required_fields'], 'email') ? 'email' : '') . ' ' . $this->Lang('email') . '<br />' .
				$this->CreateInputCheckbox($id, 'required_fields[]', 'title', strpos(' ' . $gbook['required_fields'], 'title') ? 'title' : '') . ' ' . $this->Lang('title')
	);

$smarty->assign('prompt_active',lang('active'));
$smarty->assign('active', $this->CreateInputCheckbox($id, 'active', 1, $gbook['active']));

$smarty->assign('prompt_import_csv',$this->Lang('import_csv'));
$smarty->assign('import_csv', $params['mode'] == 'add' ? '' : $this->CreateInputFile( $id, 'import_csv', 'text/xml', 40));
$smarty->assign('csv_format',$this->Lang('csv_format'));

$smarty->assign('submit',$this->CreateInputSubmit ($id, 'submitbutton', lang('submit')));
//$this->smarty->assign('apply',$params['mode'] == 'add' ? '' : $this->CreateInputSubmit($id, 'applybutton', $this->Lang('apply')));
$smarty->assign('cancel',$this->CreateInputSubmit ($id, 'cancel', lang('cancel')));

$smarty->assign('formstart', $this->CreateFormStart ($id, 'editgbook', $returnid, 'post', 'multipart/form-data', false, '', $params));
$smarty->assign('formend',$this->CreateFormEnd());

echo $this->ProcessTemplate('editgbook.tpl');

?>