<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

class Gbook_utils
{
	protected function __construct() {}

	
	public static function GetGbooks($gbook = '', $filter = true) {
		$output = array();
		
		$db = cmsms()->GetDB();
		$query = "SELECT
								g.*,
								COUNT(e.entry_id) AS entries
							FROM
								" . cms_db_prefix() . "module_gbook g
							LEFT JOIN
								" . cms_db_prefix() . "module_gbook_entries e
							ON
								g.gbook_id = e.gbook_id
							";
		if ( $filter === true )
		{
			$query .= "	AND e.active = 1
							";
		}
		$query .= "WHERE
								1 = 1
								";
		if ( ctype_digit($gbook) )
		{
			$query .= "AND g.gbook_id = ? 
								";
		}
		elseif ( !empty($gbook) )
		{
			$query .= "AND g.alias = ?
								";
		}
		if ( $filter === true )
		{
			$query .= "AND g.active = 1
								";
		}
		$query .= "GROUP BY
								g.gbook_id";
		if ( empty($gbook) )
		{
			$result = $db->Execute($query);
		}
		else
		{
			$result = $db->Execute($query, array($gbook));
		}
		if ( $result && $result->RecordCount() > 0 )
		{
		  while ( $row=$result->FetchRow() )
		  {
		    $output[] = $row;
		  }
		}
		if ( !$result )
		{
			echo 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
			exit();
		}
		return $output;

	}
	
	
	public static function GetEntries($gbook_id, $start = 1, $number = 20, $filter = 'active') {
		$start = ($start < 1) ? 0 : $start - 1;
		$output = array();

		$mod = cms_utils::get_module('Gbook');
		$db = cmsms()->GetDB();
		$query = "SELECT
								e.*, g.allow_smilies
							FROM
								" . cms_db_prefix() . "module_gbook_entries e,
								" . cms_db_prefix() . "module_gbook g
							WHERE
								e.gbook_id = g.gbook_id
								AND e.gbook_id = ?
								";
		switch ( $filter )
		{
			case 'active':
				$query .= "AND e.active = 1";
				break;
			case 'inactive':
				$query .= "AND e.active = 0";
				break;
			case 'spam':
				self::UpdateSpamrate($gbook_id, $mod->GetPreference('update_spamrate_' . $gbook_id));
				$mod->SetPreference('update_spamrate_' . $gbook_id, 0);
				$query .= "AND e.spamrate >= " . $db->Qmagic($mod->GetPreference('max_spamrate_active', 0.5) * 100);
				break;
		}
		$query .= "
							ORDER BY
								create_date DESC";
		$result = $db->SelectLimit($query, $number, $start, array($gbook_id)) ;
		if ( $result && $result->RecordCount() > 0 )
		{
		  while ( $row=$result->FetchRow() )
		  {
				$onerow = new stdClass();
				
				$onerow->entry_id = $row['entry_id'];
				$onerow->gbook_id = $row['gbook_id'];
				$onerow->name = cms_htmlentities($row['name']);
				$onerow->email = cms_htmlentities($row['email']);
				$onerow->title = cms_htmlentities($row['title']);
				$onerow->message = self::nl2pnbr(cms_htmlentities($row['message']));
				if ( $row['allow_smilies'] )
				{
					$onerow->message = self::replace_smileys($onerow->message);
				}
				$badwords = $mod->GetPreference('badwords', '');
				if ( !empty($badwords) )
				{
					$onerow->name = self::filter_badwords($onerow->name);
					$onerow->title = self::filter_badwords($onerow->title);
					$onerow->message = self::filter_badwords($onerow->message);
				}
				$onerow->rawmessage = $row['message'];
				$onerow->notify = $row['notify'];
				$onerow->ip = $row['ip'];
				$onerow->create_date = $row['create_date'];
				$onerow->modified_date = $row['modified_date'];
				$onerow->approved = $row['approved'];
				$onerow->approved_date = $row['approved_date'];
				$onerow->active = $row['active'];
				$onerow->spamrate = 0;
				
				array_push($output, $onerow);
		  }
		}
		if ( !$result )
		{
			echo 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
			exit();
		}
		return $output;
	}

	
	public static function GetEntry($entry_id) {
		$output = array();

		$db = cmsms()->GetDB();
		$query = "SELECT
								e.*, g.allow_smilies
							FROM
								" . cms_db_prefix() . "module_gbook_entries e,
								" . cms_db_prefix() . "module_gbook g									
							WHERE
								e.gbook_id = g.gbook_id
								AND e.entry_id = ?";
		$result = $db->Execute($query, array($entry_id));
		if ( $result && $result->RecordCount() > 0 )
		{
		  $row = $result->FetchRow();
			$onerow = new stdClass();
			$onerow->entry_id = $row['entry_id'];
			$onerow->gbook_id = $row['gbook_id'];
			$onerow->name = cms_htmlentities($row['name']);
			$onerow->email = cms_htmlentities($row['email']);
			$onerow->title = cms_htmlentities($row['title']);
			$onerow->message = self::nl2pnbr(cms_htmlentities($row['message']));
			if ( $row['allow_smilies'] )
			{
				$onerow->message = self::replace_smileys($onerow->message);
			}
			$mod = cms_utils::get_module('Gbook');
			$badwords = $mod->GetPreference('badwords', '');
			if ( !empty($badwords) )
			{
				$onerow->name = self::filter_badwords($onerow->name);
				$onerow->title = self::filter_badwords($onerow->title);
				$onerow->message = self::filter_badwords($onerow->message);
			}
			$onerow->rawmessage = $row['message'];
			$onerow->notify = $row['notify'];
			$onerow->ip = $row['ip'];
			$onerow->create_date = $row['create_date'];
			$onerow->modified_date = $row['modified_date'];
			$onerow->approved = $row['approved'];
			$onerow->approved_date = $row['approved_date'];
			$onerow->active = $row['active'];
			$onerow->spamrate = 0;
			$output = $onerow;
		}
		if ( !$result )
		{
			echo 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
			exit();
		}
		return $output;
	}

	
	public static function AddEntry($gbook_id, $name, $email, $title, $message, $notify = 0) {
		$mod = cms_utils::get_module('Gbook');
		
		// get gbook props
		$gbooks = self::GetGbooks($gbook_id, true);
		if ( empty($gbooks) )
		{
			$errors[] = $gbook_id;
			return array('gbook not found' => $errors);
		}
		$gbook = $gbooks[0];
		
		// check for double posts
		$ip = cms_utils::get_real_ip();
		$lastentry = self::GetEntries($gbook_id, 1, 1, false);
		if ( !empty($lastentry) && $message == $lastentry[0]->rawmessage ) 
		{
			$errors[] = $gbook_id;
			return array('double post' => $errors);
		}
		// check if the last entry has the same ip-address
		if ( $gbook['prevent_post_twice'] && $lastentry[0]->ip == $ip ) 
		{
			$errors[] = $gbook_id;
			return array('not allowed to post twice' => $errors);
		}

		// check for valid input
		$required_fields = explode(',', $gbook['required_fields'] . ',message');
		$name = strip_tags($name);
		$email = strip_tags($email);
		$title = strip_tags($title);
		if ( in_array('name',  $required_fields) && empty($name) ) $errors[] = 'name';
		if ( in_array('email', $required_fields) && !is_email($email, false) ) $errors[] = 'email';
		if ( in_array('title', $required_fields) && empty($title) ) $errors[] = 'title';
		if ( empty($message) ) $errors[] = 'message';
		
		if ( !empty($errors) )
		{
			return array('field validation errors' => $errors);
		}
		else
		{
			$active = 1;
			$spamrate = self::b8_exec('Classify', $title . ' ' . $message);
			if ( $spamrate > $mod->GetPreference('max_spamrate_active', 0.6) )
			{
				$active = 0;
			}

			if ( $spamrate <= $mod->GetPreference('max_spamrate_save', 0.9) )
			{
				$db = cmsms()->GetDB();
				$query = "INSERT INTO " . cms_db_prefix() . "module_gbook_entries 
										(gbook_id, name, email, title, message, notify, ip, create_date, modified_date, activation_code, active)
									VALUES
										(?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), ?, ?)";
				$result = $db->Execute($query, array(
						$gbook_id, 
						$name, 
						$email, 
						$title, 
						$message, 
						$notify,
						$ip,
						'',
						$active
				));
				if ( $result )
				{
					$insert_id = $db->Insert_ID();
					if ( $active == 1 )
					{
						$params['entry_id'] = $insert_id;
						$params['gbook_id'] = $gbook_id;
						$params['name'] = $name;
						$params['email'] = $email;
						$params['title'] = $title;
						$params['message'] = $message;
						$params['notify'] = $notify;
						$params['ip'] = $ip;
						$params['active'] = $active;
						$mod->SendEvent('Gbook_entry_added', $params);

						//Update search index
						$search = cms_utils::get_search_module();
						if ( $search != false )
						{
							$search->AddWords($mod->GetName(), $insert_id, 'entry', $params['title'] . ' ' . $params['message']);
						}
					}
					return array('entry added' => array($insert_id, $spamrate));
				}
				else
				{
					$errors[] = $gbook_id;
					$errors[] = 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
					return array('mysql error' => $errors);
				}
			}
			else
			{
				$errors[] = $gbook_id;
				return array('spam' => $errors);
			}
		}
	}

	
	public static function EditEntry($entry_id, $gbook_id, $name, $email, $title, $message, $notify, $active) {
		// only admin, so no need to check for valid input, just strip tags
		$name = strip_tags($name);
		$email = strip_tags($email);
		$title = strip_tags($title);

		$db = cmsms()->GetDB();
		$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET
								gbook_id = ?,
								name = ?,
								email = ?,
								title = ?,
								message = ?,
								notify = ?,
								modified_date = NOW(),
								active = ?
							WHERE
								entry_id = ?";
		$result = $db->Execute($query, array(
				$gbook_id, 
				$name, 
				$email, 
				$title, 
				$message, 
				$notify,
				$active,
				$entry_id
		));
		if ( $result )
		{
			$mod = cms_utils::get_module('Gbook');
			$params['entry_id'] = $entry_id;
			$params['gbook_id'] = $gbook_id;
			$params['name'] = $name;
			$params['email'] = $email;
			$params['title'] = $title;
			$params['message'] = $message;
			$params['notify'] = $notify;
			$params['active'] = $active;
			$mod->SendEvent('Gbook_entry_edited', $params);

			//Update search index
			$search = cms_utils::get_search_module();;
			if ( $search != false )
			{
				if ( $active == 1 )
				{
					$search->AddWords($mod->GetName(), $entry_id, 'entry', $params['title'] . ' ' . $params['message']);
				}
				else
				{
					$search->DeleteWords($mod->GetName(), $entry_id, 'entry');
				}
			}
			return true;
		}
		else
		{
			echo 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
			exit();
		}

	}

	
	public static function DeleteEntry($entry_id) {
		$db = cmsms()->GetDB();
		$query = "DELETE FROM " . cms_db_prefix() . "module_gbook_entries WHERE entry_id = ?";
		$result = $db->Execute($query, array($entry_id));
		if ( $result )
		{
			$mod = cms_utils::get_module('Gbook');
			$params['entry_id'] = $entry_id;
			$params['gbook_id'] = $gbook_id;
			$mod->SendEvent('Gbook_entry_deleted', $params);
			
			//Update search index
			$search = cms_utils::get_search_module();
			if ( $search != false )
			{
				$search->DeleteWords($mod->GetName(), $entry_id, 'entry');
			}
			return true;
		}
		else
		{
			echo 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
			exit();
		}
	}

	
	public static function UpdateSpamrate($gbook_id, $updateall) {
		$db = cmsms()->GetDB();
		$query = "SELECT
								entry_id, title, message
							FROM
								" . cms_db_prefix() . "module_gbook_entries
							WHERE
								gbook_id = ?
								";
		if ( $updateall == 0 )
		{
			$query .= "AND spamrate IS NULL";
		}
		$query .= "
							ORDER BY
								create_date DESC";
		$result = $db->Execute($query, array($gbook_id)) ;
		if ( $result && $result->RecordCount() > 0 )
		{
		  while ( $row=$result->FetchRow() )
		  {
				$spamrate = self::b8_exec('Classify', $row['title'] . ' ' . $row['message']);
				$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET spamrate = ? WHERE entry_id = ?";
				$db->Execute($query, array($spamrate * 100, $row['entry_id']));
		  }
		}
		if ( !$result )
		{
			echo 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
			echo '<pre>' . $query . '</pre>';
			exit();
		}
		return true;
	}

	
	public static function UpdateAllSpamrates() {
		$mod = cms_utils::get_module('Gbook');
		$db = cmsms()->GetDB();
		$query = "SELECT
								gbook_id
							FROM
								" . cms_db_prefix() . "module_gbook";
		$result = $db->Execute($query);
		if ( $result && $result->RecordCount() > 0 )
		{
		  while ( $row=$result->FetchRow() )
		  {
				$mod->SetPreference('update_spamrate_' . $row['gbook_id'], 1);
		  }
		}
		if ( !$result )
		{
			echo 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
			exit();
		}
		return true;

	}
	
	
	public static function GetSmileys($filter = true) {
		$smileyscache = cms_utils::get_app_data('gbook_smileys_'.$filter);
		if ( empty($smileyscache) )
		{
			$output = array();

			$db = cmsms()->GetDB();
			$query = "SELECT
									*
								FROM
									" . cms_db_prefix() . "module_gbook_smileys
								";
			if ( $filter === true )
			{
				$query .= "WHERE
									active = 1";
			}
			$query .= "
								ORDER BY
									sort ASC";
			$result = $db->Execute($query);
			if ( $result && $result->RecordCount() > 0 )
			{
				while ( $row=$result->FetchRow() )
				{
					$output[$row['smiley_id']] = $row;
					$output[$row['smiley_id']]['smiley_path'] = 'modules/Gbook/smileys/' . $row['smiley_file'];
				}
				cms_utils::set_app_data('gbook_smileys_'.$filter, serialize($output));
			}
			if ( !$result )
			{
				echo 'ERROR: ' . __LINE__ . ' » ' . mysql_error();
				exit();
			}
		}
		else
		{
			$output = unserialize($smileyscache);
		}
		return $output;
	}

	
	public static function replace_smileys($text) {
		$smileys = self::GetSmileys(false);	
		$text = ' ' . $text . ' ';
		foreach ( $smileys as $smiley )
		{
			$text = str_replace(' '.$smiley['smiley_code'].' ', ' <img src="'.$smiley['smiley_path'].'" alt="" /> ', $text);
		}
		$text = trim(str_replace('  ' , ' ', $text));
		return $text;
	}

	
	public static function nl2pnbr($text) {
		//Taken from http://www.webmasterworld.com/forum88/164.htm
		// Use \n for newline on all systems
		$text = preg_replace("/(\r\n|\n|\r)/", "\n", $text);

		// Only allow two newlines in a row.
		$text = preg_replace("/\n\n+/", "\n\n", $text);

		// Put <p>..</p> around paragraphs
		$text = preg_replace('/\n?(.+?)(\n\n|\z)/s', "<p>$1</p>", $text);

		// Convert newlines not preceded by </p> to a <br /> tag
		$text = preg_replace('|(?<!</p>)\s*\n|', "<br />", $text);

		// Convert urls to links (http://www.phpkode.com/source/p/friendica/friendica-friendica-d2bbd92/include/bbcode.php)
		$text = preg_replace("/([^\]\=]|^)(https?\:\/\/[a-zA-Z0-9\:\/\-\?\&\;\.\=\_\~\#\%\$\!\+\,]+)/ism", '$1<a href="$2" rel="nofollow" target="_blank"">$2</a>', $text);
		$text = preg_replace("/\[url\]([^\[\]]*)\[\/url\]/ism", '<a href="$1" rel="nofollow" target="_blank">$1</a>', $text);
		$text = preg_replace("/\[url\=([^\[\]]*)\](.*?)\[\/url\]/ism", '<a href="$1" rel="nofollow" target="_blank">$2</a>', $text);

    // Truncate long urls that can cause display problems (http://www.barattalo.it/2010/03/10/php-parse-url-mailto-and-also-twitters-usernames-and-arguments/)
    $text = preg_replace("/>(([[:alnum:]]+:\/\/)|www\.)([^[:space:]]".
        "{20,30})([^[:space:]]*)([^[:space:]]{10,20})([[:alnum:]#?\/&=])".
        "</", ">\\3...\\5\\6<", $text);
		return $text;
	}

	public static function filter_badwords($text) {
		$mod = cms_utils::get_module('Gbook');
		$badwords = str_replace(',', '|', $mod->GetPreference('badwords', ''));
		if ( !empty($badwords) )
		{
			// from http://www.sitepoint.com/forums/showthread.php?739688-php-bad-word-filtering
			$text = preg_replace( '/\b(?:' . $badwords . ')\b/i', '*****', $text );
		}
		return $text;
	}

	
	public static function b8_exec($action, $text) {
		$db = cmsms()->GetDB();
		$config = cmsms()->GetConfig();
		
		$config_b8 = array(
			'storage' => 'mysqli'
		);

		$config_storage = array(
			'database'   => $config['db_name'],
			'table_name' => cms_db_prefix().'module_gbook_b8_wordlist',
			'host'       => $config['db_hostname'] . (!empty($config['db_port']) ? ':' . $config['db_port'] : ''),
			'user'       => $config['db_username'],
			'pass'       => $config['db_password']
		);

		# Tell b8 to use the new-style HTML extractor
		$config_lexer = array(
			'old_get_html' => FALSE,
			'get_html'     => TRUE
		);

		# Tell the degenerator to use multibyte operations
		# (needs PHP's mbstring module! If you don't have it, set 'multibyte' to FALSE)
		$config_degenerator = array(
			'multibyte' => TRUE
		);
		
		require_once cms_join_path(dirname(__FILE__), 'b8', 'b8.php');

		try {
			$b8 = new b8($config_b8, $config_storage, $config_lexer, $config_degenerator);
		}
		catch(Exception $e) {
			echo "<b>Could not initialize b8.</b><br />\n";
			echo "<b>Error message:</b> ", $e->getMessage();
			echo "\n\n</div>\n\n</body>\n\n</html>";
			exit();
		}
		
		$text = stripslashes($text);

		switch($action)
		{
			case 'Classify':
				return $b8->classify($text);
				break;

			case 'SaveAsSpam':
				$b8->learn($text, b8::SPAM);
				return true;
				break;

			case 'SaveAsHam':
				return $b8->learn($text, b8::HAM);
				//return true;
				break;

			case 'DeleteFromSpam':
				$b8->unlearn($text, b8::SPAM);
				return true;
				break;

			case 'DeleteFromHam':
				$b8->unlearn($text, b8::HAM);
				return true;
				break;
		}
		return false;
	}
	
	public static function format_rating($rating) {
		$red   = floor(255 * $rating);
		$green = floor(255 * (1 - $rating));
		return sprintf("%01.2f", $rating) . ' <span style="display:inline-block; width:10px; height:10px; border:1px solid #666; background-color:rgb('.$red.', '.$green.', 0);"><span>';
	}

	public static function GetUsers()
	{
		$users = array();
		$gCms = cmsms();
		$groupops = $gCms->GetGroupOperations();
		$allgroups = $groupops->LoadGroups();
		foreach ($allgroups as $onegroup)
		{
			$users[lang('group') . ': ' . $onegroup->name] = $onegroup->id * -1;
		}
		$userops = $gCms->GetUserOperations();
		$allusers = $userops->LoadUsers();
		foreach ($allusers as $oneuser)
		{
			$users[$oneuser->username] = $oneuser->id;
		}
		return $users;
	}

}
?>