<?php
/**
 * A little more complex example of how you can define a "Book" with some additional parameters.
 */ 
class BookSkeleton extends OrmEntity
{
	public function __construct()
	{
		parent::__construct('ormskeleton','bookskeleton');
		
		$this->add(new OrmField('book_id'	
			, OrmCAST::$INTEGER 
			, null	
			, null 		
			, OrmKEY::$PK	
		));
		
		$this->add(new OrmField('title'	
			, OrmCAST::$STRING
			, 50	
		));
		
		$this->add(new OrmField('description'	
			, OrmCAST::$STRING
			, 255	
		));
		
		// This is a UUID : a varchar(32) in database
		// Used to store a UUID : a unique id generated by the system itself. 
		//  example : OrmCORE::generateUUID();
		$this->add(new OrmField('uuid'		
			, OrmCAST::$UUID
		));
		
		// Now we'll add more informations on our Entity
		// 1] we want to use the Mysql system auto-increment instead using a table xxx_seq like CmsMadeSimple does
		$this->garnishAutoincrement();
		
		// 2] We will propose a default value for the description OrmField
		$this->garnishDefaultValue('description',"It's a great Book");
		
		// 3] we want to be sure that the title is Unique.
		//    we also want indexing the uuid
		$this->addIndexes('title', true);
		$this->addIndexes('uuid');

	}	
}
?>