<?php
#-------------------------------------------------------------------------
# Module: Custom Global Settings
# Author: Rolf Tjassens, Jos
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/customgs
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

if( !$this->CheckPermission('Custom Global Settings - Use') )
{
	echo $this->ShowErrors(lang('needpermissionto', 'Custom Global Settings - Use'));
	return;
}

// Get the fields the user is allowed to edit.
$fields = $this->GetFields();

$rowarray = array();

foreach( $fields as $key => $fieldprops )
{
			$onerow = new stdClass();

			$onerow->fieldid = $fieldprops['fieldid'];
			$onerow->name = $fieldprops['name'];
			$onerow->type = $fieldprops['type'];
			$onerow->help = $fieldprops['help'];
			$onerow->value = $fieldprops['value'];
			$onerow->fieldclass = '';

			$fieldname = 'field[' . $fieldprops['fieldid'] . ']';
			switch ( $fieldprops['type'] )
			{
				case 'textfield':
					$size = min(50, $fieldprops['properties']);
					$onerow->fieldhtml = $this->CreateInputText($id, $fieldname, $fieldprops['value'], $size, $fieldprops['properties'] );
					break;

				case 'pulldown':
				case 'radiobuttons':
					// lets parse this by smarty first
					global $CMS_VERSION;
					if ( $CMS_VERSION >= '1.11' )
					{
						$fieldprops['properties'] = $smarty->fetch('eval:'.$fieldprops['properties']);
					}
					else
					{
						$fieldprops['properties'] = $this->ProcessTemplateFromData($fieldprops['properties']);
					}
					$fieldprops['properties'] = preg_replace('#<!--(.+)-->#is', '', $fieldprops['properties']); // filter out html comments
					$fieldprops['properties'] = str_replace("\r", "\n", $fieldprops['properties']);
					$fieldprops['properties'] = str_replace("\n\n", "\n", $fieldprops['properties']);
					$fieldprops['properties'] = trim($fieldprops['properties']);
					$properties = explode("\n", $fieldprops['properties']);
					$items = array();
					foreach ($properties as $property)
					{
						list($key, $value) = explode("|", $property . "|");
						$value = trim($value) == "" ? $key : $value;
						$items[$value] = $key;
					}
					if ( $fieldprops['type'] == 'pulldown' )
					{
						$onerow->fieldhtml = $this->CreateInputDropdown($id, $fieldname, $items, -1, $fieldprops['value']);
					}
					else
					{
						$onerow->fieldhtml = $this->CreateInputRadioGroup($id, $fieldname, $items, $fieldprops['value']);
					}
					break;

				case 'checkbox':
					$onerow->fieldhtml = $this->CreateInputCheckbox($id, $fieldname, '1', $fieldprops['value'], '');
					break;

				case 'datepicker':
				case 'timepicker':
					$onerow->fieldhtml = $this->CreateInputText($id, $fieldname, $fieldprops['value'], 10, 10);
					$onerow->fieldclass = ' ' . $fieldprops['type'];
					break;

				case 'datetimepicker':
					$onerow->fieldhtml = $this->CreateInputText($id, $fieldname, $fieldprops['value'], 16, 20);
					$onerow->fieldclass = ' ' . $fieldprops['type'];
					break;

				case 'textarea':
					$onerow->fieldhtml = $this->CreateTextArea(FALSE, $id, $fieldprops['value'], $fieldname);
					break;

				case 'wysiwyg':
					$onerow->fieldhtml = $this->CreateTextArea(TRUE, $id, $fieldprops['value'], $fieldname);
					break;

				case 'button':
					$onerow->fieldhtml = $this->CreateInputSubmit($id, $fieldname, $fieldprops['name']);
					break;

				case 'gbfilepicker':
					$onerow->fieldhtml = '';
					$gbfp = cms_utils::get_module('GBFilePicker');
					if ( $gbfp )
					{
						$onerow->fieldhtml = $gbfp->CreateFilePickerInput($gbfp, $id, $fieldname, $fieldprops['value'], array('dir'=>'images','mode'=>'browser'));
					}
					break;

				case 'colorpicker':
					$onerow->fieldhtml = $this->CreateInputText($id, $fieldname, $fieldprops['value'], 10, 10);
					$onerow->fieldclass = ' inputcolorpicker';
					break;

				case 'fieldsetstart':
					//$onerow->fieldhtml = $this->CreateFieldsetStart($id, $fieldname, $fieldprops['name']);
					$onerow->fieldhtml = '<fieldset class="cgs_fieldset"><legend class="cgs_collapsible" id="section' . $fieldprops['fieldid'] . '"><span></span> ' . $fieldprops['name'] . '</legend><div>';
					break;

				case 'fieldsetend':
					//$onerow->fieldhtml = $this->CreateFieldsetEnd();
					$onerow->fieldhtml = '</div></fieldset> <!-- end cgs_collapsible -->';
					break;
			}

	array_push ($rowarray, $onerow);
}

$smarty->assign('items', $rowarray );
$smarty->assign('submit',$this->CreateInputSubmit ($id, 'submitbutton', lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit ($id, 'cancel', lang('cancel')));
$smarty->assign('startform', $this->CreateFormStart( $id, 'save_general', $returnid ));
$smarty->assign('endform', $this->CreateFormEnd());

if ( function_exists('cms_admin_current_language') ) setlocale(LC_TIME, cms_admin_current_language()); // for cmsms 1.10 only
for ($i = 1; $i <= 12; $i++)
{
	$timestamp=mktime(1,1,1,$i,1,2000);
	$months[] = htmlentities(strftime('%B', $timestamp));
}
$monthnames = implode("','",$months);
for ($i = 1; $i <= 7; $i++)
{
	$timestamp=mktime(1,1,1,10,$i,2000);
	$days[] = htmlentities(strftime('%A', $timestamp));
	$daysmin[] = htmlentities(substr(strftime('%a', $timestamp), 0, 2));
}
$daynames = implode("','",$days);
$daynamesmin = implode("','",$daysmin);

$DP_locale = "
	$.datepicker.regional[''] = {
		closeText: '" . lang('close') . "',
		prevText: '" . lang('previous') . "',
		nextText: '" . lang('next') . "',
		currentText: '" . $this->Lang('now') . "',
		monthNames: ['" . $monthnames . "'],
		dayNames: ['" . $daynames . "'],
		dayNamesMin: ['" . $daynamesmin . "'],
		dateFormat: 'yyyy-mm-dd',
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.setDefaults($.datepicker.regional['']);

	$.timepicker.regional[''] = {
		timeOnlyTitle: '" . $this->Lang('choosetime') . "',
		timeText: '" . $this->Lang('time') . "',
		hourText: '" . lang('hour') . "',
		minuteText: '" . lang('minutes') . "',
		currentText: '" . $this->Lang('now') . "',
		closeText: '" . lang('close') . "',
		ampm: false
	};
	$.timepicker.setDefaults($.timepicker.regional['']);
";

$smarty->assign('DP_locale', $DP_locale);


echo $this->ProcessTemplate('admin_general.tpl');
?>