<?php
#CMS - CMS Made Simple
#(c)2004 by Ted Kulp (wishy@users.sf.net)
#This project's homepage is: http://www.cmsmadesimple.org
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#$Id: GCharts.module.php 2114 2005-11-04 21:51:13Z wishy $

class gcharts_admin_ops
{
  protected function __construct() {}

  public static function delete_chart($chartid)
  {
    $db = cmsms()->GetDb();

    //Now remove the chart
    $query = "DELETE FROM ".cms_db_prefix()."module_gcharts WHERE gcharts_id = ?";
    $db->Execute($query, array($chartid));

    // delete any files...
    $config = cmsms()->GetConfig;
    $p = cms_join_path($config['uploads_path'],'gcharts','id'.$chartid);
    if( is_dir($p) )
      {
	recursive_delete($p);
      }

    gcharts_admin_ops::delete_static_route($chartid);
    
    //Update search index
    $mod = cms_utils::get_module('GCharts');
    $module = cms_utils::get_module('Search');
    if ($module != FALSE)
      {
	$module->DeleteWords($mod->GetName(), $chartid, 'chart');
      }
    
    @$mod->SendEvent('GChartsChartDeleted', array('gcharts_id' => $chartid));
	// put mention into the admin log
	audit($chartid, 'GCharts: '.$chartid, 'Chart deleted');
  }


  public static function handle_upload($itemid,$fieldname,&$error)
  {
    $config = cmsms()->GetConfig();
	  
    $mod = cms_utils::get_module('GCharts');
    $p = cms_join_path($config['uploads_path'],'gcharts');
    if (!is_dir($p)) {
      $res = @mkdir($p);
      if( $res === FALSE )
	{
	  $error = $mod->Lang('error_mkdir',$p);
	  return FALSE;
	}
    }

    $p = cms_join_path($config['uploads_path'],'gcharts','id'.$itemid);
    if (!is_dir($p)) {
      if( @mkdir($p) === FALSE )
	{
	  $error = $mod->Lang('error_mkdir',$p);
	  return FALSE;
	}
    }

    if( $_FILES[$fieldname]['size'] > $config['max_upload_size'] )
      {
	$error = $mod->Lang('error_filesize');
	return FALSE;
      }

    $filename = basename($_FILES[$fieldname]['name']);
    $dest = cms_join_path($config['uploads_path'],'gcharts','id'.$itemid,$filename);

    // Get the files extension
    $ext = substr(strrchr($filename, '.'), 1);

    // compare it against the 'allowed extentions'
    $exts = explode(',',$mod->GetPreference('allowed_upload_types',''));
    if( !in_array( $ext, $exts ) ) 
      {
	$error = $mod->Lang('error_invalidfiletype');
	return FALSE;
      }

    if( @cms_move_uploaded_file($_FILES[$fieldname]['tmp_name'], $dest) === FALSE )
      {
	$error = $mod->Lang('error_movefile',$dest);
	return FALSE;
      }

    return $filename;
  }


  public static function AdminCreateTemplateList( $id, $returnid, $prefix, $defaulttemplatepref, 
						  $active_tab, $defaultprefname, $name )
  {
    // we're gonna allow multiple templates here
    // but we're gonna prefix them all with something
    $gCms = cmsms();
    $mod = cms_utils::get_module('GCharts');
    $smarty = cmsms()->GetSmarty();
    
    $falseimage1 = $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif','make default','','','systemicon');
    $trueimage1 = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif','default','','','systemicon');
    $alltemplates = $mod->ListTemplates();
    $rowarray = array();
    $rowclass = 'row1';
    foreach( $alltemplates as $onetemplate )
      {
	if( !preg_match("/^$prefix/", $onetemplate ) )
	  {
	    continue;
	  }
	
	$tmp = substr($onetemplate,strlen($prefix));
	$row = new StdClass();
	$row->name = $mod->CreateLink( $id, 'edittemplate', $returnid,
				       $tmp, array('template' => $tmp,
						   'active_tab' => $active_tab,
						   'name'=>$name,
						   'prefix'=>$prefix,
						   'mode'=>'edit'));
	$row->rowclass = $rowclass;

	$default = ($mod->GetPreference($defaultprefname) == $tmp) ? true : false;
	if( $default )
	  {
	    $row->default = $trueimage1;
	  }
	else
	  {
	    $row->default = $mod->CreateLink( $id, 'makedefaulttemplate', $returnid,
					      $falseimage1,
					      array('template'=>$tmp,
						    'defaultprefname'=>$defaultprefname,
						    'active_tab' => $active_tab));
	  }

	$row->editlink = $mod->CreateLink( $id, 'edittemplate', $returnid,
					   $gCms->variables['admintheme']->
					   DisplayImage ('icons/system/edit.gif',
							 $mod->Lang ('edit'), '', '', 'systemicon'),
					   array ('template' => $tmp,
						  'active_tab' => $active_tab,
						  'prefix'=>$prefix,
						  'name'=>$name,
						  'mode'=>'edit'));
	
	$tmp = $prefix."default";
	if( ($onetemplate == $tmp) || $default )
	  {
	    $row->deletelink = '&nbsp;';
	  }
	else
	  {
	    $row->deletelink = $mod->CreateLink( $id, 'deletetemplate', $returnid,
						 $gCms->variables['admintheme']->
						 DisplayImage ('icons/system/delete.gif',
							       $mod->Lang ('delete'), '', '', 'systemicon'),
						 array ('template' => $onetemplate),
						 $mod->Lang ('areyousure'));
	  }
	
	array_push ($rowarray, $row);
	($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
      }
    
    $smarty->assign('items', $rowarray );
    $smarty->assign('nameprompt', $mod->Lang('prompt_name'));
    $smarty->assign('defaultprompt', $mod->Lang('prompt_default'));

    $smarty->assign('newtemplatelink',
		    $mod->CreateLink( $id, 'edittemplate', $returnid,
				      $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $mod->Lang('prompt_newtemplate'),'','','systemicon'),
				      array('prefix' => $prefix,
					    'active_tab' => $active_tab,
					    'name'=>$name,
					    'mode' => 'add',
					    'defaulttemplatepref' => $defaulttemplatepref),
				      '', false, false, '').' '.

		    $mod->CreateLink( $id, 'edittemplate', $returnid,
				      $mod->Lang('prompt_newtemplate'),
				      array('prefix' => $prefix,
					    'active_tab' => $active_tab,
					    'name'=>$name,
					    'mode' => 'add',
					    'defaulttemplatepref' => $defaulttemplatepref
					    )));
    $smarty->assign($mod->CreateFormEnd());
    echo $mod->ProcessTemplate('edittemplates.tpl');
  }


  /*---------------------------------------------------------
   _AdminEditDefaultTemplateForm
   NOT PART OF THE MODULE API

   A function that provides a form for editing a default template
   and/or returning it to system defaults.
   ---------------------------------------------------------*/
  public static function AdminEditDefaultTemplateForm($id,$returnid,$prefname,$active_tab,$name,
						      $filename,$info)
  {
    $mod = cms_utils::get_module('GCharts');
    $smarty = cms_utils::get_smarty();
    $smarty->assign('defaulttemplateform_name',$name);
    $smarty->assign('info_name',$info);
    $smarty->assign('startform',
		    $mod->CreateFormStart($id,'setdefaulttemplate',$returnid,'post','',false,'',
					   array('prefname'=>$prefname,
						 'active_tab'=>$active_tab,
						 'filename'=>$filename)));
    $smarty->assign('prompt_template',$mod->Lang('template'));
    $smarty->assign('input_template',$mod->CreateTextArea(false,$id,
							   $mod->GetPreference($prefname),
							   'input_template'));
    $smarty->assign('submit',$mod->CreateInputSubmit($id,'submit',$mod->Lang('submit')));
    $smarty->assign('reset',$mod->CreateInputSubmit($id,'resettodefault',
						     $mod->Lang('resettodefault')));
    $smarty->assign('endform',
		    $mod->CreateFormEnd());
    echo $mod->ProcessTemplate('editdefaulttemplate.tpl');
  }


  public static function CreateParentDropdown($id, $catid = -1, $selectedvalue = -1)
  {
    $db = cmsms()->GetDb();
    $mod = cms_utils::get_module('GCharts');

    $longname = '';      
    $items['('.$mod->Lang('none').')'] = '-1';
      
    $query = "SELECT hierarchy, gcharts_category_name FROM ".cms_db_prefix()."module_gcharts_categories WHERE gcharts_category_id = ?";
    $dbresult = $db->Execute($query, array($catid));
    while ($dbresult && $row = $dbresult->FetchRow())
      {
	$longname = $row['hierarchy'] . '%';
      }
      
    $query = "SELECT gcharts_category_id, gcharts_category_name, hierarchy, gcharts_category_name FROM ".cms_db_prefix()."module_gcharts_categories WHERE hierarchy not like ? ORDER by hierarchy";
    $dbresult = $db->Execute($query, array($longname));
    while ($dbresult && $row = $dbresult->FetchRow())
      {
	$items[$row['gcharts_category_name']] = $row['gcharts_category_id'];
      }

    return $mod->CreateInputDropdown($id, 'parent', $items, -1, $selectedvalue);
  }


  static public function UpdateHierarchyPositions()
  {
    $db = cmsms()->GetDb();

    $query = "SELECT gcharts_category_id, gcharts_category_name FROM ".cms_db_prefix()."module_gcharts_categories";
    $dbresult = $db->Execute($query);
    while ($dbresult && $row = $dbresult->FetchRow())
      {
	$current_hierarchy_position = "";
	$current_gcharts_category_name = "";
	$content_id = $row['gcharts_category_id'];
	$current_parent_id = $row['gcharts_category_id'];
	$count = 0;
	  
	while ($current_parent_id > -1)
	  {
	    $query = "SELECT gcharts_category_id, gcharts_category_name, parent_id FROM ".cms_db_prefix()."module_gcharts_categories WHERE gcharts_category_id = ?";
	    $row2 = $db->GetRow($query, array($current_parent_id));
	    if ($row2)
	      {
		$current_hierarchy_position = str_pad($row2['gcharts_category_id'], 5, '0', STR_PAD_LEFT) . "." . $current_hierarchy_position;
		$current_gcharts_category_name = $row2['gcharts_category_name'] . ' | ' . $current_gcharts_category_name;
		$current_parent_id = $row2['parent_id'];
		$count++;
	      }
	    else
	      {
		$current_parent_id = 0;
	      }
	  }
	  
	if (strlen($current_hierarchy_position) > 0)
	  {
	    $current_hierarchy_position = substr($current_hierarchy_position, 0, strlen($current_hierarchy_position) - 1);
	  }
	  
	if (strlen($current_gcharts_category_name) > 0)
	  {
	    $current_gcharts_category_name = substr($current_gcharts_category_name, 0, strlen($current_gcharts_category_name) - 3);
	  }
	  
	$query = "UPDATE ".cms_db_prefix()."module_gcharts_categories SET hierarchy = ?, gcharts_category_name = ? WHERE gcharts_category_id = ?";
	$db->Execute($query, array($current_hierarchy_position, $current_gcharts_category_name, $content_id));
      }
  }
  static public function delete_static_route($gcharts_chart_id)
  {
    return cms_route_manager::del_static('','GCharts',$gcharts_chart_id);
  }
} // end of class

#
# EOF
#
?>
