<?php
#-------------------------------------------------------------------------
#
# Clip Magic, <admin@clipmagic.com.au>
# Web: www.clipmagic.com.au
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class listit2fd_XLink extends ListIt2FielddefBase
{
    private $_xlink;

	public function __construct(&$db_info) 
	{	
        parent::__construct($db_info);
        
        $this->SetFriendlyType($this->ModLang('fielddef_'.$this->GetType()));
    }
    
    static public function GetModuleDeps() {        
        return array();
   	}
	
	public function GetXLink()
	{
		if(isset($this->_xlink))
			return $this->_xlink;
						
		$this->_xlink = new XLink();		
		return $this->GetXLink();	
	}
    
    public function GetLI2Instances() {
        // Admin template       
        // Get active LI modules only including id, module name and friendly name
        // return array $limods
        
        $li2 = cms_utils::get_module('ListIt2');
        $alllimods = $li2->ListModules();
        $limods = array();
        
        foreach ($alllimods as $onemod) {
           	$mod = cms_utils::get_module($onemod->module_name);
            $available = cms_utils::module_available($onemod->module_name);
            
            if (is_object($mod) && $available) {
                $onemod->friendly_name = $mod->GetFriendlyName();
                
                $limods[] = $onemod;
            }
        }
                
            if(count($limods > 0)) {
            	$options = array();
                $options = array_merge(array('' => $this->ModLang('select_one')));
                foreach($limods as $option) {                
                    $options[$option->module_id] = $option->friendly_name;                    
                }
            }            
            return $options;
    }
    
    public function GetLI2ModuleFields ($li2module) {
		// Admin template        
        // Get list of fields for selected LI2 custom module
        // return array
        
        $options = array();
        $fields = array();
        
        $mod = cms_utils::get_module($li2module);
        $available = cms_utils::module_available($li2module);
        
        
        if (is_object($mod) && $available) {
        
		// Load from database
		$db = cmsms()->GetDb();
		
		$query = "SELECT * FROM " . cms_db_prefix() . "module_" . $mod->_GetModuleAlias() . "_fielddef GROUP BY fielddef_id ORDER BY position";	
		$dbr = $db->Execute($query);

		$options = array();
        $options = array_merge(array('' => $this->ModLang('select_one')));
		while ($dbr && $row = $dbr->FetchRow()) {
			$options[$row['fielddef_id']] = $row['name'];
		}			
		return $options;
        }            
    }
    
    public function RemoteFieldSource () {    
    // Admin template 
    // Radio group to select remote name, alias or custom field
    
    	$items = array();
    	$items[] = $this->ModLang('item_title');
    	$items[] = $this->ModLang('item_alias');
    	$items[] = $this->ModLang('item_custom_field');
    	return $items;
    }
    
    public function GetRemoteOptions() {
    	// Input template
    	// Retrieve data from remote LI2 module
  
  		$db = cmsms()->GetDb();
  	
      	$limod_id = $this->GetOptionValue('limod_options');
    	$query = "SELECT `module_name` FROM " . cms_db_prefix() . "module_listit2_instances WHERE `module_id` = ?";
    	$limod_name = $db->GetOne($query, array($limod_id));
    	
    	
		$mod = cms_utils::get_module($limod_name);
		$available = cms_utils::module_available($limod_name);
		$options = array();
        $options = array_merge(array('' => $this->ModLang('select_one')));
    	
    	
   		$datasrc_opt = $this->GetOptionValue('datasrc_options');
    	$modfield_opt = $this->GetOptionValue('modfield_options');
    	
 	
    	switch ($datasrc_opt) {
    		case 0:  // title
				
        		if (is_object($mod) && $available) {
					// Load from database
					$query = "SELECT `item_id`, `title` FROM " . cms_db_prefix() . "module_" . $mod->_GetModuleAlias() . "_item WHERE `active` = 1";	
					if (!$dbr = $db->Execute($query)){
						echo $db->sql;
						die;						
					}

					while ($dbr && $row = $dbr->FetchRow()) {
						$options[$row['item_id']] = $row['title'];
					}			
        		}
    			break;
    			
    		case 1:  // alias
        		if (is_object($mod) && $available) {
					// Load from database
					$query = "SELECT `item_id`, `alias` FROM " . cms_db_prefix() . "module_" . $mod->_GetModuleAlias() . "_item WHERE `active` = 1";	
					if (!$dbr = $db->Execute($query)){
						echo $db->sql;
						die;						
					}

					while ($dbr && $row = $dbr->FetchRow()) {
						$options[$row['item_id']] = $row['alias'];
					}			
        		}
    			break;
    			
    		case 2:  // custom fielddef
				if (is_object($mod) && $available) {
					$query = "SELECT * FROM " . cms_db_prefix() . "module_" . $mod->_GetModuleAlias() . "_fieldval WHERE `fielddef_id` = ?";	
					if (!$dbr = $db->Execute($query,array($modfield_opt))){
						echo $db->sql;
						die;						
					}

					while ($dbr && $row = $dbr->FetchRow()) {
						$options[$row['item_id'] . '::' . $row['fielddef_id']] = $row['value'];
					}			
    			}
    			
    			break;
    			
     		default:
     			return 'not getting anything';
     			break;
   			
    	
    	}    
		return $options;    
    }
        

}// end of class
?>