<?php
# Module
$lang['module_friendlyname'] = 'ListIt XLinks';
$lang['module_description'] = 'ListItExtended Cross Links module';

# Global
$lang['select_one'] = 'Please select one';
$lang['li2_module'] = 'ListIt2 module';
$lang['li2_field'] = 'Field Name';
$lang['required_field_empty'] = 'Required field is empty';
$lang['error'] = 'Oops! Something went amiss';
$lang['insufficient_params'] = 'Insufficient parameters in XLink module tag';
$lang['remote_item_unavailable'] = 'The remote item in the remote module is unavailable';
$lang['remote_field_unavailable'] = 'The remote field in the remote module is unavailable';
$lang['remote_module_unavailable'] = 'The remote module is unavailable';


$lang['item_title'] = 'Title';
$lang['item_alias'] = 'Alias';
$lang['item_custom_field'] = 'Custom field';
$lang['item_data_from'] = 'Get data from';

$lang['item_data_from_help'] = 'Choose the field from which the remote item data should be retrieved';


$lang['fielddef_XLink'] = 'LI2 XLink';
$lang['fielddef_limod_options'] = 'Available ListIt2 Modules';
$lang['fielddef_limod_dropdown_help'] = 'Select one from the available modules in the list';

$lang['fielddef_modfield_options'] = 'Available custom fields in the selected module';
$lang['fielddef_modfield_dropdown_help'] = 'Select one from the available fields in the list';


$lang['param=_fielddef_id'] = 'does this appear?';

# Help, Paramaters and Change Log

$lang['help'] = '<h3>What does this do?</h3>
<p>This module allows you to pull information contained in fields from multiple ListIt2 instances into your current ListIt2 instance.  The information may be the remote modules&apos; <em>Title</em>, <em>Alias</em> or data from a custom field definition.</p>
<p>In short, it takes the concept of Categories and Hierarchies one step further. Each ListI2 custom module can have as many fields as you like and in the information can be shared, either directly in another module OR assigned to a variable and then used
to display a list of items from another module that meet the criteria, eg:</p>
<ul>
<li>You may have a ListIt2 instance of <em>Authors</em> that has lots of custom fields including images, contact details, etc.</li>
<li>You may have a ListIt2 instance of <em>Publishers</em> that has lots of custom fields including images, contact details, etc.</li>
<li>You may have a ListIt2 instance of <em>Books</em> that has lots of custom fields including images, etc. In the <em>Books</em> module you can add XLink fields to the <em>Author</em> and <em>Publisher</em> modules.</li>
<li>You could then display a detail page for an <em>Author</em> and then use the XLink info assigned to a variable, to call a summary list of all books by that author.</li>
<li>Ditto for <em>Publishers</em></li>
</ul>

<p>The possibilities are endless.  It&apos;s up to your imagination and template skills!</p>

<h3>Who should use this module?</h3>
<p>You must have a working knowledge of ListIt2 and Field Definitions and at least 2 standalone custom ListIt2 instances.</p>



<h3>How do I use it?</h3>
	<p><strong>Field Definition Tab</strong></p> 
	<ul>     
	<li>Add a ListIt2XLink (LI2 XLink) field definition to your current LI2 instance.</li>
	<li>From the dropdown, select the remote module that has the info you need in your current module.</li>
	<li>Hit <em>Submit</em> (known anomaly in ListIt2 v1.4 that <em>Apply</em> may create two custom fields). By default, this will store the item_id and, on the front end, display the corresponding <em>Title</em>	 of the remote instance in your current module instance.</li>
	<li>To switch the selection to either the remote alias or a custom field, edit the newly created XLink field definition. Now you will have a radio button choice of <em>Title</em>, <em>Alias</em> or <em>Custom field</em>.  When <em>Custom field</em> is
	chosen, an ajax call is made to the remote module and a dropdown field is displayed showing the remote custom fields. Select one and <em>Submit</em>.</li>
	</ul> 
	<p><strong>In your templates</strong></p> 
	<p>To ensure that the information displayed (or assigned to a variable) on the front end is current and to avoid database bloat, no data from remote modules is stored in your current XLink field definition - only ids. This means a little bit more processing
	is required by your current module to output the correct data. To do this, you need to place the following module call tag in your template:<br />
	<em>{ListIt2XLink fielddef_id=$fielddef->GetId() mod=$mod->GetName() item_id=$item->item_id }</em>.</p>
	<p><strong>Please note:</strong> the previous example accesses the fielddef obj via a loop, eg in the default <em>Summary Template</em>, change if from:</p>
	<pre>
		{if !empty($item-&gt;fielddefs)}
		&lt;!-- field definitions --&gt;
		&lt;div class="item-properties"&gt;
			{foreach from=$item-&gt;fielddefs item=fielddef}
	
			{*
				Categories were moved to field definitions.
				If you need Categories, create new Field definition with alias "category"
				and Categories will be available again.
			*}
	
			{if $fielddef.type == &apos;Categories&apos; && ($fielddef.value != &apos;&apos;)}
	
			{* use ListIt2Loader plugin if you need Category information in default module action templates *}
			{ListIt2Loader item=&apos;category&apos; force_array=1 value=$fielddef.value assign=&apos;cats&apos;}
	
			&lt;!-- categories --&gt;
			&lt;div class="item-category"&gt;
				Category: {$cats|implode:&apos;,&apos;}
			&lt;/div&gt;
			&lt;!-- categories //--&gt;
			{/if}
	
			{if $fielddef.value && $fielddef.type != &apos;Categories&apos;}
				{if $fielddef.type == &apos;SelectFile&apos; || $fielddef.type == &apos;FileUpload&apos;}
					{$fielddef.name}: &lt;a href="{$fielddef-&gt;GetImagePath(true)}/{$fielddef.value}"&gt;{$fielddef.value}&lt;/a&gt;&lt;br /&gt;
				{elseif $fielddef.type == &apos;SelectDateTime&apos;}
					{$fielddef.name}: {$fielddef.value|cms_date_format}&lt;br /&gt;
				{else}
					{$fielddef.name}: {$fielddef.value}&lt;br /&gt;
				{/if}
			{/if}
	
			{/foreach}
		&lt;/div&gt;
		&lt;!-- field definitions //--&gt;
	
	</pre>
	<p>to</p>
	<pre>
        {if !empty($item-&gt;fielddefs)}
        &lt;!-- field definitions --&gt;
        &lt;div class="item-properties"&gt;
            {foreach from=$item-&gt;fielddefs item=fielddef}
    

            {if $fielddef.type == &apos;Categories&apos; && ($fielddef.value != &apos;&apos;)}
    
            {* use ListIt2Loader plugin if you need Category information in default module action templates *}
            {ListIt2Loader item=&apos;category&apos; force_array=1 value=$fielddef.value assign=&apos;cats&apos;}
    
            &lt;!-- categories --&gt;
            &lt;div class="item-category"&gt;
                Category: {$cats|implode:&apos;,&apos;}
            &lt;/div&gt;
            &lt;!-- categories //--&gt;
            {/if}
    
            {if $fielddef.value && $fielddef.type != &apos;Categories&apos;}
                {if $fielddef.type == &apos;SelectFile&apos; || $fielddef.type == &apos;FileUpload&apos;}
                    {$fielddef.name}: &lt;a href="{$fielddef-&gt;GetImagePath(true)}/{$fielddef.value}"&gt;{$fielddef.value}&lt;/a&gt;&lt;br /&gt;
                {elseif $fielddef.type == &apos;SelectDateTime&apos;}
                    {$fielddef.name}: {$fielddef.value|cms_date_format}&lt;br /&gt;
                {elseif $fielddef.type == &apos;XLink&apos;}
                    {$fielddef.name}: {ListIt2XLink fielddef_id=$fielddef-&gt;GetId() mod=$mod-&gt;GetName() item_id=$item-&gt;item_id }
                {else}
                    {$fielddef.name}: {$fielddef.value}&lt;br /&gt;
                {/if}
            {/if}
    
            {/foreach}
        &lt;/div&gt;
        &lt;!-- field definitions //--&gt;
        {/if}
	</pre>
	
	<p>When not in a loop for fielddefs, directy access the fielddef as normal, eg:<br />
	<em>{ListIt2XLink fielddef_id=$item->fielddefs.myxlinkfield->GetId() mod=$mod->GetName() item_id=$item->item_id }</em><br />

<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit the cms development forge at <a href="http://dev.cmsmadesimple.org">dev.cmsmadesimple.org</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author(s), Clip Magic can sometimes be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author(s) directly.</li>  
</ul>
<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2013, Clip Magic <a href="mailto:admin@clipmagic.com.au">&lt;admin@clipmagic.com.au&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>

';
$lang['help_param_mod'] = 'Module name of the current ListIt2 custom instance. <strong>This parameter MUST be entered manually. Do not rely on the default value.</strong>';
$lang['help_param_fielddef_id'] = 'Field definition id of the XLink fielddef in the current module. Refer examples above. <strong>This parameter MUST be entered manually. Do not rely on the default value.</strong>';
$lang['help_param_item_id'] = 'The item id of the currently displayed front end item. <strong>This parameter MUST be entered manually. Do not rely on the default value.</strong>';
	    
?>